% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GA-estimation.R
\name{Lorenz.GA}
\alias{Lorenz.GA}
\title{Estimates the parameter vector in Lorenz regression using a genetic algorithm}
\usage{
Lorenz.GA(
  y,
  x,
  standardize = TRUE,
  weights = NULL,
  popSize = 50,
  maxiter = 1500,
  run = 150,
  suggestions = NULL,
  ties.method = c("random", "mean"),
  ties.Gini = c("random", "mean"),
  seed.random = NULL,
  seed.Gini = NULL,
  seed.GA = NULL,
  parallel.GA = FALSE
)
}
\arguments{
\item{y}{a vector of responses}

\item{x}{a matrix of explanatory variables}

\item{standardize}{Should the variables be standardized before the estimation process? Default value is TRUE.}

\item{weights}{vector of sample weights. By default, each observation is given the same weight.}

\item{popSize}{Size of the population of candidates in the genetic algorithm. Default value is 50.}

\item{maxiter}{Maximum number ot iterations in the genetic algorithm. Default value is 1500.}

\item{run}{Number of iterations without improvement in the best fitness necessary for the algorithm to stop. Default value is 150.}

\item{suggestions}{Initial guesses used in the genetic algorithm. The default value is \code{NULL}, meaning no suggestions are passed.
Other possible values are a numeric matrix with at most \code{popSize} rows and \code{ncol(x)} columns, or a character string "OLS".
In the latter case, \code{0.5*popSize} suggestions are created as random perturbations of the OLS solutions.}

\item{ties.method}{What method should be used to break the ties in optimization program. Possible values are "random" (default value) or "mean". If "random" is selected, the ties are broken by further ranking in terms of a uniformly distributed random variable. If "mean" is selected, the average rank method is used.}

\item{ties.Gini}{what method should be used to break the ties in the computation of the Gini coefficient at the end of the algorithm. Possible values and default choice are the same as above.}

\item{seed.random}{An optional seed for generating the vector of uniform random variables used to break ties in the genetic algorithm. Defaults to \code{NULL}, which means no specific seed is set.}

\item{seed.Gini}{An optional seed for generating the vector of uniform random variables used to break ties in the computation of the Gini coefficient. Defaults to \code{NULL}, meaning no specific seed is applied.}

\item{seed.GA}{An optional seed for \code{\link[GA]{ga}}, used during the fitting of the genetic algorithm. Defaults to \code{NULL}, implying that no specific seed is set.}

\item{parallel.GA}{Whether parallel computing should be used to distribute the computations in the genetic algorithm. Either a logical value determining whether parallel computing is used (TRUE) or not (FALSE, the default value). Or a numerical value determining the number of cores to use.}
}
\value{
A list with several components:
\describe{
   \item{\code{theta}}{the estimated vector of parameters.}
   \item{\code{LR2}}{the Lorenz-\eqn{R^2} of the regression.}
   \item{\code{Gi.expl}}{the estimated explained Gini coefficient.}
   \item{\code{niter}}{number of iterations attained by the genetic algorithm.}
   \item{\code{fit}}{value attained by the fitness function at the optimum.}
}
}
\description{
\code{Lorenz.GA} estimates the coefficient vector of the single-index model.
It also returns the Lorenz-\eqn{R^2} of the regression as well as the estimated explained Gini coefficient.
}
\details{
The genetic algorithm is solved using function \code{\link[GA]{ga}} from the \emph{GA} package. The fitness function is coded in Rcpp to speed up computation time.
When discrete covariates are introduced and ties occur in the index, the default option randomly breaks them, as advised in Section 3 of Heuchenne and Jacquemain (2022)

The parameters \code{seed.random}, \code{seed.Gini}, and \code{seed.GA} allow for local seed setting to control randomness in specific parts of the function.
Each seed is applied to the respective part of the computation, and the seed is reverted to its previous state after the operation.
This ensures that the seed settings do not interfere with the global random state or other parts of the code.
}
\section{References}{

Heuchenne, C. and A. Jacquemain (2022). Inference for monotone single-index conditional means: A Lorenz regression approach. \emph{Computational Statistics & Data Analysis 167(C)}.
}

\examples{
data(Data.Incomes)
y <- Data.Incomes$Income
x <- cbind(Data.Incomes$Age, Data.Incomes$Work.Hours)
Lorenz.GA(y, x, popSize = 40)

}
\seealso{
\code{\link{Lorenz.Reg}}, \code{\link[GA]{ga}}
}
