% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_helper.R
\name{Datetime_breaks}
\alias{Datetime_breaks}
\title{Create a (shifted) sequence of Datetimes for axis breaks}
\usage{
Datetime_breaks(x, shift = lubridate::duration(12, "hours"), by = "1 day")
}
\arguments{
\item{x}{a vector of \code{Datetimes}}

\item{shift}{a \code{numeric} giving the number of  \code{duration} object, e.g.
\code{lubridate::duration(12, "hours")}}

\item{by}{a \code{character} scalar giving the unit of the interval in
\code{\link[base:seq]{base::seq()}}}
}
\value{
a \code{vector} of \code{Datetimes}
}
\description{
Take a vector of Datetimes and create a sequence of Datetimes with a given
shift and interval. This is a helper function to create breaks for plotting,
e.g. in \code{\link[=gg_days]{gg_days()}}, and is best used in conjunction with
\code{\link[=Datetime_limits]{Datetime_limits()}}. The function is a thin wrapper around \code{\link[=seq]{seq()}}.
}
\examples{
dataset <- c("2023-08-15", "2023-08-20")
Datetime_breaks(dataset)
Datetime_breaks(dataset, shift = 0)
Datetime_breaks(dataset, by = "12 hours")
}
