% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Friedman.R
\name{Friedman}
\alias{Friedman}
\alias{rcbd.friedman}
\title{Friedman Test}
\description{
Performs Friedman test on samples collected in a randomized complete block design.
}
\examples{
t <- pmt(
    "rcbd.friedman", n_permu = 0
)$test(Table4.5.3)$print()

t$type <- "asymp"
t

}
\section{Super classes}{
\code{\link[LearnNonparam:PermuTest]{LearnNonparam::PermuTest}} -> \code{\link[LearnNonparam:RCBDTest]{LearnNonparam::RCBDTest}} -> \code{Friedman}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Friedman-new}{\code{Friedman$new()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="plot"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-plot'><code>LearnNonparam::PermuTest$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="print"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-print'><code>LearnNonparam::PermuTest$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="test"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-test'><code>LearnNonparam::PermuTest$test()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Friedman-new"></a>}}
\if{latex}{\out{\hypertarget{method-Friedman-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Friedman} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Friedman$new(type = c("permu", "asymp"), n_permu = 10000)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{a character string specifying the way to calculate the p-value.}

\item{\code{n_permu}}{an integer indicating number of permutations for the permutation distribution. If set to \code{0}, all permutations will be used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Friedman} object.
}
}
}
