% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prepare_Graph_Input.R
\name{censor_family_onsets}
\alias{censor_family_onsets}
\title{Censor onset times in a family based on a proband's end of follow-up.}
\usage{
censor_family_onsets(
  tbl,
  proband_id_col,
  cur_proband,
  start,
  end,
  event,
  status_col = "status",
  aod_col = "aod",
  age_eof_col = "age"
)
}
\arguments{
\item{tbl}{tibble with info on family members, censoring events based on cur_proband in proband_id_col, must contain start, end, and event as columns}

\item{proband_id_col}{column name of proband ids within family}

\item{cur_proband}{current proband id}

\item{start}{start of follow up, typically birth date, must be a date column}

\item{end}{end of follow up, must be a date column}

\item{event}{event of interest, typically date of diagnosis, must be a date column}

\item{status_col}{column name of status column to be created. Defaults to "status.}

\item{aod_col}{column name of age of diagnosis (aod) column to be created. Defaults to "aod".}

\item{age_eof_col}{column name of age at end of follow-up (eof) column to be created. Defaults to "age_eof".}
}
\value{
tibble with updated end times, status, age of diagnosis, and age at end of follow-up for a family, such that proband's end time is used as the end time for all family members. This prevents
 using future events to based predictions on.
}
\description{
This function censors onset times for family members based on the proband's end of follow-up. This is done to prevent using future events to base predictions on.
}
\examples{
# See Vignettes.
}
