
#'
#' PCQDA_Test
#' 
#' PCQDA_Test is the test set of the PCQDA model. It consists of Cluster2, Age, 
#' MeanDNE.Apex, TotalDNE.TotalPolygonFaces, Proportion.DNEunder0.0001, and 
#' Proportion.DNEover0.6. The number of rows is 186.
#' 
#' @export
#' 
PCQDA_Test<-{
  Cluster2 <- c(3, 4, 3, 3, 2, 2, 2, 3, 2, 3, 3, 2, 1, 2, 2, 3, 2, 3, 3, 3, 3, 3, 2, 2, 3, 3, 2, 2, 1, 2, 1, 2, 4, 2, 2, 2, 3, 3, 3, 2, 3, 1, 2, 2, 1, 2, 2, 2, 2, 1, 4, 3, 3, 2, 2, 2, 2, 3, 2, 2, 2, 3, 2, 3, 1, 4, 2, 2, 2, 3, 3, 3, 4, 2, 2, 2, 2, 3, 2, 2, 2, 2, 3, 2, 
                2, 2, 1, 1, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 2, 1, 1, 2, 2, 1, 2, 2, 2, 3, 1, 2, 2, 2, 2, 2, 4, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 3, 3, 1, 2, 1, 4, 4, 2, 4, 2, 2, 3, 2, 2, 2, 2, 3, 3, 3, 3, 2, 2, 3, 2, 2, 2, 2, 4, 2, 2, 2, 2, 3, 3, 3)
  
  Age<- c(72, 87, 72, 79, 56, 67, 73, 75, 33, 76, 75, 46, 20, 35, 60, 69, 68, 77, 80, 86, 85, 76, 69, 69, 75, 68, 68, 31, 28, 56, 23, 72, 94, 32, 67, 34, 70, 87, 79, 67, 76, 25, 45, 46, 20, 41, 41, 62, 62, 23, 80, 65, 78, 64, 45, 72, 69, 76, 43, 60, 58, 79, 52, 74, 29, 82, 57, 59, 59, 69, 77, 70, 83, 47, 61, 61, 68, 75, 31, 60, 43, 43, 75, 57, 69, 52, 29, 29, 82, 63, 35, 65, 
          38, 67, 33, 69, 52, 67, 49, 63, 56, 56, 46, 34, 57, 39, 63, 38, 50, 62, 48, 48, 25, 70, 68, 55, 28, 31, 54, 35, 39, 44, 28, 28, 35, 70, 29, 46, 46, 38, 71, 25, 67, 60, 60, 49, 49, 80, 43, 68, 37, 37, 43, 35, 67, 43, 49, 76, 32, 32, 38, 86, 78, 30, 47, 39, 96, 96, 49, 83, 52, 42, 85, 45, 74, 36, 62, 88, 80, 70, 67, 72, 72, 83, 63, 67, 67, 55, 96, 61, 74, 66, 58, 93, 87, 83) 
  MeanDNE.Apex <- c(0.033187, 0.038596, 0.030157, 0.036915, 0.034419, 0.036122, 0.039402, 0.036226, 0.028308, 0.036599, 0.034535, 0.032797, 0.025030, 0.031610, 0.030580, 0.036367, 0.037042, 0.038272, 0.033328, 0.046001, 0.039771, 0.044713, 0.030387, 0.042356, 0.037207, 0.042720, 0.037589, 0.030477, 0.023185, 0.040110, 0.027494, 0.032163, 0.047235, 0.033609, 0.035849, 0.027690, 0.040131, 0.040018, 0.044165, 0.032204, 0.047362, 0.023893, 0.036372, 0.031462, 0.032122, 0.027282, 0.024191, 0.040049, 0.034451, 0.031714, 0.041252, 0.036428, 0.037955, 0.030663, 0.025469, 0.032570, 0.032714, 0.037361, 0.030964, 0.033303, 0.029428, 0.042030, 0.031296, 0.044775, 
                    0.032642, 0.035279, 0.030727, 0.027799, 0.033488, 0.029659, 0.034925, 0.039604, 0.035453, 0.032111, 0.035655, 0.035693, 0.040303, 0.039104, 0.029960, 0.039680, 0.039369, 0.031921, 0.039048, 0.034242, 0.034271, 0.027799, 0.036168, 0.024885, 0.039432, 0.037745, 0.026843, 0.032911, 0.032292, 0.031837, 0.027837, 0.037310, 0.035795, 0.035356, 0.033995, 0.039680, 0.034128, 0.032873, 0.027001, 0.026086, 0.035381, 0.031029, 0.032824, 0.030532, 0.033895, 0.037102, 0.028942, 0.031995, 0.028102, 0.032873, 0.037172, 0.034748, 0.026863, 0.026001, 0.035114, 0.028180, 0.030446, 0.031894, 0.029748, 0.026037, 0.030818, 0.035921, 0.032567, 0.034800, 0.033151, 0.031540, 0.041991, 0.024603, 0.034582, 0.039318, 0.033446, 0.030109, 0.036075, 0.037911, 0.026143, 0.031332, 0.031522, 0.026031, 0.031928, 0.031356, 0.034320, 0.033040, 0.027588, 0.038353, 0.031530, 0.031530, 0.026930, 0.037693, 0.033199, 0.032098, 0.027960, 0.029360, 0.038122, 0.044811, 0.037544, 0.034497, 0.039012, 0.037185, 0.044536, 0.030558, 0.039436, 0.035623, 0.032327, 0.038320, 0.042604, 0.033232, 0.040474, 0.040142, 0.039972, 0.045751, 0.038035, 0.042449, 0.035886, 0.032180, 0.040876, 0.037771, 0.038590, 0.032937, 0.031973, 0.036164, 0.045553, 0.038832)
  
  TotalDNE.TotalPolygonFaces <- c(0.029517, 0.025195, 0.028578, 0.027568, 0.022448, 0.024587, 0.023750, 0.027648, 0.020585, 0.022577, 0.028520, 0.022849, 0.020226, 0.015824, 0.027095, 0.027610, 0.024825, 0.025392, 0.031221, 0.033949, 0.026184, 0.022283, 0.025257, 0.021120, 0.030457, 0.023810, 0.023463, 0.018366, 0.014517, 0.027023, 0.016368, 0.025978, 0.051624, 0.014008, 0.028943, 0.017215, 0.026839, 0.030905, 0.028831, 0.024627, 0.027865, 0.015801, 0.021693, 0.017383, 0.014993, 0.019934, 0.016081, 0.028433, 0.021544, 0.012892, 0.023067, 0.029585, 0.025569, 0.026475, 0.015555, 0.021957, 0.027779, 0.032912, 0.023941, 0.023764, 0.026951, 0.023730, 
                                  0.018810, 0.028436, 0.015161, 0.024213, 0.027809, 0.028283, 0.028080, 0.026334, 0.029408, 0.026923, 0.022153, 0.019358, 0.026623, 0.027068, 0.023467, 0.027600, 0.015159, 0.019069, 0.019176, 0.017681, 0.028827, 0.024539, 0.034059, 0.025407, 0.017154, 0.018832, 0.031646, 0.028637, 0.017045, 0.023548, 0.015161, 0.028516, 0.014506, 0.026831, 0.025664, 0.022017, 0.019246, 0.025481, 0.024012, 0.017856, 0.022260, 0.016819, 0.016481, 0.017380, 0.019668, 0.016834, 0.020765, 0.021467, 0.021279, 0.022555, 0.017770, 0.026204, 0.028046, 0.017665, 0.014017, 0.020207, 0.021255, 0.022299, 0.019085, 0.019477, 0.017618, 0.014803, 0.019786, 0.028813, 0.019138, 0.016499, 0.015748, 0.015094, 0.023888, 0.015358, 0.025039, 0.022783, 0.025317, 0.017625, 0.016937, 0.030020, 0.023869, 0.029179, 0.014527, 0.022463, 0.016219, 0.014741, 0.022804, 0.018071, 0.021606, 0.025073, 0.013179, 0.020920, 0.015805, 0.030035, 0.028199, 0.019410, 0.021564, 0.016286, 0.026096, 0.028873, 0.020057, 0.026269, 0.023307, 0.016433, 0.024873, 0.021479, 0.022850, 0.018663, 0.023668, 0.027316, 0.023662, 0.029812, 0.025036, 0.021908, 0.021292, 0.028926, 0.023924, 0.021601, 0.025378, 0.024656, 0.032194, 0.025788, 0.029415, 0.020904, 0.032053, 0.025473, 0.028766, 0.027641)
  
  Proportion.DNEunder0.0001 <- c(0.004631, 0.004620, 0.004405, 0.004697, 0.004712, 0.004393, 0.004619, 0.004203, 0.006369, 0.004590, 0.004673, 0.005346, 0.005709, 0.004811, 0.005084, 0.004001, 0.004330, 0.004061, 0.004897, 0.005168, 0.004442, 0.004472, 0.004412, 0.004488, 0.003944, 0.004839, 0.005063, 0.005362, 0.005385, 0.004328, 0.005734, 0.004677, 0.002784, 0.005997, 0.004969, 0.005691, 0.004192, 0.004016, 0.004410, 0.004805, 0.004697, 0.005367, 0.005900, 0.005084, 0.005169, 0.006063, 0.005507, 0.004830, 0.004318, 0.006092, 0.004737, 0.004076, 0.004817, 0.004496, 0.005488, 0.004945, 0.004490, 0.004478, 0.005117, 0.004409, 0.005174, 0.004685, 0.004618, 0.004342, 0.006296, 0.003855, 0.005473, 0.004664, 0.004539, 0.004336, 0.004630, 0.003870, 0.004826, 0.004559, 0.005210, 0.004762, 0.004730, 0.004369, 0.005408, 0.004197, 0.004637, 0.005247, 
                                 0.005149, 0.005111, 0.006928, 0.004397, 0.005397, 0.005916, 0.005734, 0.005021, 0.005497, 0.004615, 0.005914, 0.005085, 0.006118, 0.004737, 0.005428, 0.004795, 0.006290, 0.004364, 0.005076, 0.004795, 0.005038, 0.005480, 0.005209, 0.005344, 0.004758, 0.004712, 0.004856, 0.004313, 0.005035, 0.005311, 0.004381, 0.005122, 0.005081, 0.005072, 0.006361, 0.005412, 0.005083, 0.004091, 0.005296, 0.005815, 0.005579, 0.005520, 0.005169, 0.004574, 0.006066, 0.005861, 0.005830, 0.005939, 0.004380, 0.005797, 0.004884, 0.004791, 0.003748, 0.005261, 0.005588, 0.004039, 0.005820, 0.004476, 0.005948, 0.005821, 0.005829, 0.005889, 0.004103, 0.005092, 0.005107, 0.004754, 0.005848, 0.005848, 0.005269, 0.004584, 0.004004, 0.005864, 0.005281, 0.007106, 0.004029, 0.003828, 0.005127, 0.004667, 0.005007, 0.005374, 0.004002, 0.005101, 0.004615, 0.004740, 0.004986, 0.003892, 0.004371, 0.004662, 0.004601, 0.004366, 0.004569, 0.003862, 0.004916, 0.004581, 0.004654, 0.005164, 0.002033, 0.004130, 0.004827, 0.005023, 0.004660, 0.004040, 0.004416, 0.004591) 
  Proportion.DNEover0.6 <- c(0.001730, 0.002063, 0.001728, 0.001865, 0.001483, 0.001611, 0.002117, 0.001844, 0.000953, 0.001846, 0.001997, 0.001288, 0.000777, 0.000944, 0.001593, 0.001628, 0.001616, 0.002212, 0.002193, 0.002048, 0.002145, 0.001822, 0.001629, 0.001647, 0.001841, 0.002602, 0.001631, 0.001034, 0.000890, 0.001498, 0.000714, 0.001904, 0.003796, 0.001026, 0.001666, 0.000589, 0.001728, 0.002925, 0.001836, 0.001033, 0.001571, 0.000813, 0.001257, 0.001082, 0.000721, 0.001175, 0.001241, 0.001515, 0.001722, 0.001875, 0.002079, 0.001469, 0.001835, 0.001593, 0.001059, 0.001478, 0.001544, 0.001328, 0.001416, 0.001309, 0.001494, 0.002258, 0.001387, 0.002084, 0.000853, 0.001705, 0.001484, 0.001418, 0.001612, 0.001431, 0.001838, 0.001830, 0.001375, 0.001275, 0.001381, 0.001622, 0.001629, 0.001652, 0.001999, 0.001523, 0.001140, 0.001138, 0.001990, 
                             0.001644, 0.001040, 0.001560, 0.000816, 0.000813, 0.002003, 0.001634, 0.000949, 0.001857, 0.001082, 0.001610, 0.000878, 0.001530, 0.001598, 0.001946, 0.001550, 0.001533, 0.001268, 0.001458, 0.001280, 0.001008, 0.001743, 0.001081, 0.001386, 0.001252, 0.001060, 0.001513, 0.001267, 0.001224, 0.001072, 0.001712, 0.001610, 0.001415, 0.000838, 0.000948, 0.001292, 0.001032, 0.001063, 0.001343, 0.000903, 0.000848, 0.001184, 0.001731, 0.000970, 0.001259, 0.001364, 0.001066, 0.002419, 0.002080, 0.001550, 0.001520, 0.001541, 0.001273, 0.001291, 0.001096, 0.001357, 0.001612, 0.001070, 0.001071, 0.001063, 0.000947, 0.001397, 0.001604, 0.001057, 0.001560, 0.000958, 0.000958, 0.001232, 0.002372, 0.001824, 0.000914, 0.001449, 0.001085, 0.002349, 0.001526, 0.001295, 0.001966, 0.001351, 0.001086, 0.002058, 0.001740, 0.001460, 0.001067, 0.001509, 0.002079, 0.001942, 0.001657, 0.002032, 0.001735, 0.001807, 0.001928, 0.001538, 0.001635, 0.001628, 0.001413, 0.002082, 0.001722, 0.001451, 0.001531, 0.001485, 0.002501, 0.002164, 0.001926)
  
  PCQDA_Test <- data.frame(Cluster2, Age, MeanDNE.Apex, TotalDNE.TotalPolygonFaces, Proportion.DNEunder0.0001, Proportion.DNEover0.6)
  PCQDA_Test
}

#' @examples 
#' PCQDA_Test

