% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/character_get.alpha.error.R
\name{get.alpha.error}
\alias{get.alpha.error}
\title{get.alpha.error}
\usage{
get.alpha.error(x, p2alpha = TRUE, output = "list")
}
\arguments{
\item{x}{text string to process.}

\item{p2alpha}{Logical. If TRUE detects and extracts alpha errors denoted with a critical p-value (may lead to some false positive detections).}

\item{output}{One of c("list","vector"). If output="list" returns a list containing: alpha_error, \cr
corrected_alpha, alpha_from_CI, alpha_max, alpha_min. If output="vector" returns unique alpha errors but no distinction of types.}
}
\value{
Numeric. Vector with identified alpha-error/s.
}
\description{
Extracts reported and corrected alpha error from text and 1-alpha confidence intervalls.
}
\examples{
x<-c("The threshold for significance was adjusted to .05/2",
"Type 1 error rate was alpha=.05.")
get.alpha.error(x)
x<-c("We used p<.05 as level of significance.",
     "We display .95 CIs and use an adjusted alpha of .10/3.",
     "The effect was significant with p<.025.")
get.alpha.error(x)
}
\seealso{
\code{\link[JATSdecoder]{study.character}} for extracting multiple study characteristics at once.
}
