#' 2017-18 through 2021-22 English Premier League Tea, Statistics
#'
#' A dataset containing team statistics for the English Premier League
#'
#' @format A data frame with 100 rows and 29 variables:
#' \describe{
#'   \item{squad}{Team or club name}
#'   \item{season}{Season}
#'   \item{num_players}{Number of players used in the season}
#'   \item{age}{Age of players weighted by minutes played}
#'   \item{poss}{Possession as a percentage of passes attempted}
#'   \item{goals}{Goals scored by team}
#'   \item{assists}{Assists by team}
#'   \item{goals_assists}{Goals scored plus assists by team}
#'   \item{non_pen_goals}{Non-penalty goals scored by team}
#'   \item{pen_goals}{Penalty kick goals scored by team}
#'   \item{pen_att}{Penalty kick attempts by team}
#'   \item{yellow_cards}{Yellow cards earned by team}
#'   \item{red_cards}{Red cards earned by team}
#'   \item{xG}{Expected goals}
#'   \item{non_pen_xG}{Non-penalty kick expected goals}
#'   \item{xA}{Expected assists}
#'   \item{non_pen_xGxA}{Non-penalty kick expected goals and assists}
#'   \item{prg_carry}{Progressive carries}
#'   \item{prg_pass}{Progressive passes}
#'   \item{goals_p90}{Goals per ninety minutes}
#'   \item{assists_p90}{Assists per ninety minutes}
#'   \item{goals_assists_p90}{Goals and assists per ninety minutes}
#'   \item{non_pen_goals_p90}{Non-penalty kick goals per ninety minutes}
#'   \item{non_pen_goals_assists_p90}{Non-penalty kick goals and assists per ninety minutes}
#'   \item{xG_p90}{Expected goals per ninety minutes}
#'   \item{xA_p90}{Expected assists per ninety minutes}
#'   \item{xG_xA_p90}{Expected goals plus assists per ninety minutes}
#'   \item{non_pen_xG_p90}{Expected goals minus penalty goals per ninety minutes}
#'   \item{non_pen_xG_xA_p90}{Expected goals plus assists minus penalty goals per ninety minutes}
#' }
#'
#' @source \url{https://fbref.com/en/comps/9/2021-2022/stats/2021-2022-Premier-League-Stats}
"epl_team_stats"
