% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{SplitListOfVCFs}
\alias{SplitListOfVCFs}
\title{Split each VCF into SBS, DBS, and ID VCFs (plus
VCF-like data frame with left-over rows)}
\usage{
SplitListOfVCFs(
  list.of.vcfs,
  variant.caller,
  max.vaf.diff = 0.02,
  num.of.cores = 1,
  suppress.discarded.variants.warnings = TRUE,
  always.merge.SBS = FALSE,
  chr.names.to.process = NULL
)
}
\arguments{
\item{list.of.vcfs}{List of VCFs as in-memory data frames. The VCFs should
have \code{VAF} and \code{read.depth} information added. See
\code{ReadVCFs} for more details.}

\item{variant.caller}{Name of the variant caller that produces the VCF, can
be either \code{"strelka"}, \code{"mutect"}, \code{"freebayes"} or
\code{"unknown"}. If variant caller is \code{"mutect"}, do \strong{not} merge
SBSs into DBS.}

\item{max.vaf.diff}{The maximum difference of VAF, default value is 0.02. If
the absolute difference of VAFs for adjacent SBSs is bigger than
\code{max.vaf.diff}, then these adjacent SBSs are likely to be "merely"
asynchronous single base mutations, opposed to a simultaneous doublet
mutation or variants involving more than two consecutive bases. Use negative
value (e.g. -1) to suppress merging adjacent SBSs to DBS.}

\item{num.of.cores}{The number of cores to use. Not available on Windows
unless \code{num.of.cores = 1}.}

\item{suppress.discarded.variants.warnings}{Logical. Whether to suppress
warning messages showing information about the discarded variants. Default
is TRUE.}

\item{always.merge.SBS}{If \code{TRUE} merge adjacent SBSs as DBSs regardless
of VAFs and regardless of the value of \code{max.vaf.diff}. It is an error
to set this to \code{TRUE} when \code{variant.caller = "mutect"}.}

\item{chr.names.to.process}{A character vector specifying the chromosome
names in VCF whose variants will be kept and processed, other chromosome
variants will be discarded. If \code{NULL}(default), all variants will be kept
except those on chromosomes with names that contain strings "GL", "KI",
"random", "Hs", "M", "JH", "fix", "alt".}
}
\description{
Split each VCF into SBS, DBS, and ID VCFs (plus
VCF-like data frame with left-over rows)
}
\section{Value}{
 A list containing the following objects:
\itemize{
\item \code{SBS}: List of VCFs with only single base substitutions.
\item \code{DBS}: List of VCFs with only doublet base substitutions as called
by Mutect.
\item \code{ID}: List of VCFs with only small insertions and deletions.
\item \code{discarded.variants}: \strong{Non-NULL only if} there are variants
that were excluded from the analysis. See the added extra column
\code{discarded.reason} for more details.
}
}

\examples{
file <- c(system.file("extdata/Mutect-vcf",
                      "Mutect.GRCh37.s1.vcf",
                      package = "ICAMS"))
list.of.vcfs <- ReadVCFs(file, variant.caller = "mutect")
split.vcfs <- SplitListOfVCFs(list.of.vcfs, variant.caller = "mutect")
}
