% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{compute_nearest_neighbor_distances}
\alias{compute_nearest_neighbor_distances}
\title{Compute Nearest Neighbor Distances}
\usage{
compute_nearest_neighbor_distances(
  coordinates,
  distance = "haversine",
  R = 6371
)
}
\arguments{
\item{coordinates}{A matrix of coordinates with two columns.}

\item{distance}{A character string: "haversine" (default) or "euclidean".}

\item{R}{Radius of the Earth in kilometers. Default is 6371.}
}
\value{
A numeric vector of nearest neighbor distances, in meters (haversine) or in map units (euclidean).
}
\description{
Calculates nearest neighbor distances using geodesic or Euclidean distance.
}
\examples{
# Example with geographic (longitude/latitude) coordinates
set.seed(123)
coords_geo <- matrix(cbind(runif(10, -10, 10), runif(10, 40, 50)), ncol = 2)
nnd_haversine <- compute_nearest_neighbor_distances(coords_geo, distance = "haversine")
print(round(nnd_haversine, 2))  # in km

# Example with projected coordinates (Euclidean)
coords_proj <- matrix(runif(20), ncol = 2) * 100  # e.g., meters or map units
nnd_euclidean <- compute_nearest_neighbor_distances(coords_proj, distance = "euclidean")
print(round(nnd_euclidean, 2))

}
