% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2026-01-21_s4_class_methods.R
\name{galaxy_start_workflow}
\alias{galaxy_start_workflow}
\alias{galaxy_start_workflow,character-method}
\alias{galaxy_start_workflow,Galaxy-method}
\title{Generic start workflow}
\usage{
galaxy_start_workflow(
  x,
  workflow_id,
  inputs = NULL,
  dataset_id = NULL,
  galaxy_url = "https://usegalaxy.eu"
)

\S4method{galaxy_start_workflow}{character}(
  x,
  workflow_id,
  inputs = NULL,
  dataset_id = NULL,
  galaxy_url = "https://usegalaxy.eu"
)

\S4method{galaxy_start_workflow}{Galaxy}(x, workflow_id, inputs = NULL, dataset_id = NULL)
}
\arguments{
\item{x}{A \code{Galaxy} object, or a history ID (\code{character}) to use the default
method.}

\item{workflow_id}{Character. Galaxy workflow ID.}

\item{inputs}{Named list. Optional workflow input mapping; keys are workflow
input step IDs, values are lists describing datasets/parameters.}

\item{dataset_id}{Character. ID of the input dataset (HDA). Ignored if
\code{inputs} is supplied. When \code{x} is a \code{Galaxy} and \code{dataset_id} is missing,
\code{x@input_dataset_id} is used.}

\item{galaxy_url}{Base URL of the Galaxy instance, used by the character
method. If \code{GALAXY_URL} is set it takes precedence.}
}
\value{
For the character method, a character scalar invocation ID. For the
\code{Galaxy} method, the modified \code{Galaxy} object.
}
\description{
\code{galaxy_start_workflow()} is an S4 generic. With \code{x} as a character vector
it is treated as a history ID: the given workflow is invoked in that history
and the invocation ID is returned. With \code{x} as a \code{Galaxy} object, the
history ID and URL are taken from the object; the workflow is started and
the object is updated with the resulting \code{invocation_id}.
}
