% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onebasis_inla.R
\name{onebasis_inla}
\alias{onebasis_inla}
\title{Create a One-Dimensional Basis for INLA}
\usage{
onebasis_inla(covariate, fun, basis_name, ...)
}
\arguments{
\item{covariate}{A numeric vector representing the covariate}

\item{fun}{A character string specifying the shape function to be used by
\code{\link[dlnm]{onebasis}}.}

\item{basis_name}{A character string giving a base name for the columns in the
resulting basis matrix. The default prefix (usually \code{"b"}) is replaced by this string.}

\item{...}{Additional arguments passed to \code{\link[dlnm]{onebasis}}, such as
\code{degree}, \code{df}, \code{knots}, etc.}
}
\value{
An object of class \code{"onebasis"}, as returned by \code{\link[dlnm]{onebasis}},
with column names modified according to \code{basis_name}.
}
\description{
This function is a wrapper around \link[dlnm]{onebasis} to
create a one-dimensional basis for spline modeling. This wrapper enhances the
original function by allowing users to specify a custom prefix for the column
names using the \code{basis_name} argument, such that each set of basis variables can
be easily identified in the model formula by the \pkg{INLA} framework.
}
\examples{

# Import example data set
data("dengue_MS")

# Build a one-dimensional spline basis with a custom name
ob_inla <- onebasis_inla(
 covariate = dengue_MS$tmin,
 fun = "bs",
 basis_name = "tempBasis",
 degree = 2
)

# Check class of the one-basis object
class(ob_inla)

# View first rows of the one-basis matrix
head(ob_inla)

}
