% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standing_area_gnfi3.R
\name{standing_area_gnfi3_core}
\alias{standing_area_gnfi3_core}
\title{Core Function for the Estimation of Tree Standing Areas According to the 3rd
German National Forest Inventory}
\usage{
standing_area_gnfi3_core(species_id, dbh_cm, params)
}
\arguments{
\item{species_id}{Vector of species ids (see
\code{\link{standing_area_gnfi3}}), but for this core function to work,
\code{species_id} must be provided as \code{character}. This will and
should be not checked inside this function, because if used as intended,
that has happened before calling it. The codings must either follow the
\emph{ger_nfi_2012}, the \emph{tum_wwk_short}, or the \emph{bavrn_state_short} coding.}

\item{dbh_cm}{Vector of breast height diameters (see
\code{\link{standing_area_gnfi3}})}

\item{params}{A data frame that defines the function parameters corresponding
to the species coding represented by \code{species_id}}
}
\value{
A vector with estimates of the trees' standing areas in m²
}
\description{
See documentation of \code{\link{standing_area_gnfi3}} for most information,
this function is the workhorse behind, and should never be called directly by
a user. The function \code{standing_area_gnfi3} is fully vectorized, inputs
are recyled according to the tibble rules
}
\keyword{internal}
