% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stand_diameters_and_heights.R
\name{h_q}
\alias{h_q}
\title{Quadratic Mean Height}
\usage{
h_q(h, d, n_rep = 1, na_h.rm = FALSE)
}
\arguments{
\item{h}{vector of tree height values to calculate the quadratic mean height
from}

\item{d}{vector of stem diameters at breast height corresponding to h, must
therefore have the same length as h}

\item{n_rep}{vector of representation numbers (typically the number of trees
per ha corresponding to the diameter at the same position), will be used as
individual weights for each height, together with the squared diameters d.
If n_rep has length 1, it will be recycled to the length of d. Otherwise,
if the length of n_rep does not correspond to the length of d, the function
will terminate with an error.}

\item{na_h.rm}{logical; if \code{TRUE}, records with \code{NA} heights will
be excluded from \code{h}, \code{d}, and \code{n_rep}. If \code{FALSE},
\code{NA} height values are kept and will lead to the function returning
\code{NA}.}
}
\value{
the quadratic mean height value resulting from the input data
}
\description{
The quadratic mean height is the stand height corresponding to the quadratic
mean diameter \code{\link{d_q}}. It is actually the basal area weighted
average height of a tree in the stand of interest. Insofar, its name is
somewhat misleading.
}
\examples{
# Evaluate a sample of equally weighted trees
d_cm <- c(12, 13, 25, 27, 28, 26, 26.1, 32, 35, 31, 42)
dq_cm <- d_q(d_cm)
h_m <- 0.9 * dq_cm * (d_cm / dq_cm)^0.8 # quick plausible height estim.
h_q(h_m, d_cm) # quadratic mean height
mean(h_m) # the arithmetic mean height is not the same!

# Assume, the same sample are trees from an angle count sample, where each
# tree represents a basal area of 4 m²/ha
n_rep_ha <- 4 / ((d_cm / 100)^2 * pi / 4) # representation number of each tree
h_q(h_m, d_cm, n_rep_ha)
# Interestingly, the h_q obtained here is the same as the unweighted
# arithmetic mean height above. The reason: the n_rep_ha used here act as
# inverse basal area weights, which is exactly compensated by the basal
# area weights coming from d_cm.


# Typical application to a set of single tree data grouped by survey
# time and species
library(dplyr)
oldopt <- options(fe_spec_lang = "eng") # display colloquial species names
# extract the tree data to allow insights into the mechanics
trees <- mm_forest_1_fe_stand_spatial$trees |> filter(!removal)
trees |>
  group_by(species_id, time_yr) |>
  summarise(
    n_ha   = round(sum(n_rep_ha)),
    d_q_cm = d_q(dbh_cm, n_rep_ha),
    h_q_m  = h_q(height_m, dbh_cm, n_rep_ha)
  ) |>
  print(n = Inf)
options(oldopt) # set species name display to previous value

}
\seealso{
Other stand heights: 
\code{\link{h_100}()},
\code{\link{h_dom_weise}()},
\code{\link{h_q_from_d_q}()}
}
\concept{stand heights}
