% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLM_Exact_Design.R
\name{MLM_Exact_Design}
\alias{MLM_Exact_Design}
\title{rounding algorithm for multinomial logit models}
\usage{
MLM_Exact_Design(
  J,
  k.continuous,
  design_x,
  design_p,
  var_names = NULL,
  det.design,
  p,
  ForLion,
  bvec,
  bvec_matrix,
  delta2,
  L,
  N,
  hfunc,
  link
)
}
\arguments{
\item{J}{number of response levels in the multinomial logit model}

\item{k.continuous}{number of continuous factors}

\item{design_x}{the matrix with rows indicating design point which we got from the approximate design}

\item{design_p}{the corresponding approximate allocation}

\item{var_names}{Names for the design factors. Must have the same length asfactor.level. Defaults to "X1", "X2", ...}

\item{det.design}{the determinant of the approximate design}

\item{p}{number of parameters}

\item{ForLion}{TRUE or FALSE, TRUE: this approximate design was generated by ForLion algorithm,
FALSE: this approximate was generated by EW ForLion algorithm}

\item{bvec}{If ForLion==TRUE assumed parameter values of model parameters beta, same length of h(y)}

\item{bvec_matrix}{If ForLion==FALSE the matrix of the sampled parameter values of beta}

\item{delta2}{points with distance less than that will be merged}

\item{L}{vector: rounding factors}

\item{N}{total number of observations}

\item{hfunc}{function for obtaining model matrix h(y) for given design point y, y has to follow the same order as n.factor}

\item{link}{link function, default "continuation", other choices "baseline", "cumulative", and "adjacent"}
}
\value{
x.design              matrix with rows indicating design point

ni.design             exact allocation

rel.efficiency        relative efficiency of the Exact and Approximate Designs
}
\description{
rounding algorithm for multinomial logit models
}
\examples{
J=3
k.continuous=1
design_x<-c(0.0000,103.5451,149.2355)
design_p<-c(0.2027, 0.3981, 0.3992)
det.design=54016609
p=5
theta = c(-1.935, -0.02642, 0.0003174, -9.159, 0.06386)
hfunc.temp = function(y){
   matrix(data=c(1,y,y*y,0,0,0,0,0,1,y,0,0,0,0,0), nrow=3,
            ncol=5, byrow=TRUE)
}
link.temp = "continuation"
MLM_Exact_Design(J=J, k.continuous=k.continuous,design_x=design_x,
design_p=design_p,det.design=det.design,p=p,ForLion=TRUE,bvec=theta,
delta2=1,L=0.5,N=1000,hfunc=hfunc.temp,link=link.temp)
}
