% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localSearch.R
\name{tabu}
\alias{tabu}
\title{Tabu Search}
\usage{
tabu(
  start = NULL,
  numNeigh = NULL,
  tamTabuList = 5,
  iter = 100,
  iterNoImprovement = NULL,
  intensification = NULL,
  iterIntensification = 50,
  interPercentaje = 75,
  tamIntermediateMemory = 5,
  diversification = NULL,
  iterDiversification = 50,
  forgetTabuList = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{start}{Binary vector with the set of initial features}

\item{numNeigh}{The number of neighbor to consider in each iteration. By default: all posibles. It is important to note that a high value of this parameter considerably increases the computation time.}

\item{tamTabuList}{The size of the tabu list. By default: 5}

\item{iter}{The number of iterations of the algorithm. By default: 100}

\item{iterNoImprovement}{Number of iterations without improvement to start/reset the intensification/diversification phase. By default, it is not taken into account (all iterations are performed)}

\item{intensification}{Number of times the intensification phase is applied. None by default}

\item{iterIntensification}{Number of iterations of the intensification phase}

\item{interPercentaje}{Percentage of the most significant features to be taken into account in the intensification phase}

\item{tamIntermediateMemory}{Number of best solutions saved in the intermediate memory}

\item{diversification}{Number of times the diversification phase is applied. None by default}

\item{iterDiversification}{Number of iterations of the diversification phase}

\item{forgetTabuList}{Forget tabu list for intensification/diversification phases. By default: TRUE}

\item{verbose}{Print the partial results in each iteration}
}
\value{
Returns a search function that is used to guide the feature selection process.
}
\description{
Generates a search function based on the tabu search. This function is called internally within the \code{\link{searchAlgorithm}} function. The Tabu Search\insertCite{glover1986}{FSinR} \insertCite{glover1990}{FSinR} method starts with a certain set of features and in each iteration it searches among its neighbors to advance towards a better solution. The method has a memory (tabu list) that prevents returning to recently visited neighbors. The method ends when a certain number of iterations are performed, or when a certain number of iterations are performed without improvement, or when there are no possible neighbors. Once the method is finished, an intensification phase can be carried out that begins in the space of the best solutions found, or a diversification phase can be carried out in which solutions not previously visited are explored.
}
\examples{
\donttest{ 

## The direct application of this function is an advanced use that consists of using this 
# function directly and performing a search process in a feature space
## Classification problem

# Generates the filter evaluation function
filter_evaluator <- filterEvaluator('IEConsistency')

# Generates the search function wit Tabu search
ts_search <- tabu()
# Performs the search process directly (parameters: dataset, target variable and evaluator)
ts_search(iris, 'Species', filter_evaluator)
}
}
\references{
\insertAllCited{}
}
\author{
Francisco Aragón Royón
}
