% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psdVal.R
\name{psdVal}
\alias{psdVal}
\title{Finds Gabelhouse lengths (for PSD calculations) for a species.}
\usage{
psdVal(
  species = "List",
  group = NULL,
  units = c("mm", "cm", "in"),
  addLens = NULL,
  addNames = NULL,
  incl.zero = TRUE,
  showJustSource = FALSE
)
}
\arguments{
\item{species}{A string that contains the species name for which to find Gabelhouse lengths. See details.}

\item{group}{A string that contains the sub-group of \code{species} for which to find the Gabelhouse lengths; e.g., things like \dQuote{landlocked}, \dQuote{lentic}.}

\item{units}{A string that indicates the units for the returned lengths. Choices are \code{mm} for millimeters (DEFAULT), \code{cm} for centimeters, and \code{in} for inches.}

\item{addLens}{A numeric vector that contains minimum length definitions for additional categories. See details.}

\item{addNames}{A string vector that contains names for the additional length categories added with \code{addLens}. See details.}

\item{incl.zero}{A logical that indicates if a zero is included in the first position of the returned vector (DEFAULT) or not. This position will be named \dQuote{substock}. See details.}

\item{showJustSource}{A logical that indicates whether just the literature source information should be returned (\code{TRUE}) or not. If \code{TRUE} this will NOT return any of the Gabelhouse length information.}
}
\value{
A vector of minimum values for length categories for the chosen species.
}
\description{
Returns a vector with the five Gabelhouse lengths for a chosen species.
}
\details{
Finds the Gabelhouse lengths from \code{data(PSDlit)} for the species given in \code{species}. The species name must be spelled exactly (including capitalization) as it appears in \code{data(PSDlit)}. Type \code{psdVal()} to see the list of species and how they are spelled.

A zero is included in the first position of the returned vector if \code{incl.zero=TRUE}. This is useful when computing PSD values with a data.frame that contains fish smaller than the stock length.

Additional lengths may be added to the returned vector with \code{addLens}. Names for these lengths can be included as names in \code{addLens} or separately in \code{addNames}. If \code{addNames} is NULL and \code{addLens} is not named then the default category names will be the lengths from \code{addLens}. The \code{addLens} argument is useful for calculating PSD values that are different from the Gabelhouse lengths.

See examples and \href{https://fishr-core-team.github.io/FSA/articles/Computing_PSDs.html}{this article} for a demonstration.
}
\section{IFAR Chapter}{
 6-Size Structure.
}

\examples{
#===== List all available species in PSDlit
psdVal()

#===== Typical usages
psdVal("Bluegill")
psdVal("Bluegill",units="in")
psdVal("Bluegill",units="in",incl.zero=FALSE)
psdVal("Bluegill",showJustSource=TRUE)

#===== For species that have sub-groups
psdVal("Brown Trout",group="lentic")
psdVal("Brown Trout",group="lotic")
psdVal("Palmetto Bass",group="revised")
psdVal("Palmetto Bass",group="original")

#===== Adding user-defined categories
#-----   with lengths and names separately in addLens= and addNames=
psdVal("Bluegill",units="in",addLens=7)
psdVal("Bluegill",units="in",addLens=7,addNames="MinLen")
psdVal("Bluegill",units="in",addLens=c(7,9),addNames=c("MinSlot","MaxSlot"))
#-----   with a named vector in addLens=
psdVal("Bluegill",units="in",addLens=c("MinLen"=7))
psdVal("Bluegill",units="in",addLens=c("MinSlot"=7,"MaxSlot"=9))

}
\references{
Ogle, D.H. 2016. \href{https://fishr-core-team.github.io/fishR/pages/books.html#introductory-fisheries-analyses-with-r}{Introductory Fisheries Analyses with R}. Chapman & Hall/CRC, Boca Raton, FL.

Guy, C.S., R.M. Neumann, and D.W. Willis. 2006. New terminology for proportional stock density (PSD) and relative stock density (RSD): proportional size structure (PSS). Fisheries 31:86-87. [Was (is?) from http://pubstorage.sdstate.edu/wfs/415-F.pdf.]

Guy, C.S., R.M. Neumann, D.W. Willis, and R.O. Anderson. 2006. Proportional size distribution (PSD): A further refinement of population size structure index terminology. Fisheries 32:348. [Was (is?) from http://pubstorage.sdstate.edu/wfs/450-F.pdf.]

Willis, D.W., B.R. Murphy, and C.S. Guy. 1993. Stock density indices: development, use, and limitations. Reviews in Fisheries Science 1:203-222. [Was (is?) from http://web1.cnre.vt.edu/murphybr/web/Readings/Willis\%20et\%20al.pdf.]
}
\seealso{
See \code{\link{psdCalc}}, \code{\link{psdPlot}}, \code{\link{psdAdd}}, \code{\link{PSDlit}}, \code{\link{tictactoe}}, \code{\link{lencat}}, and \code{\link{rcumsum}} for related functionality.
}
\author{
Derek H. Ogle, \email{DerekOgle51@gmail.com}
}
\keyword{manip}
