% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec_flag_non_east_pacific.R
\name{ec_flag_non_east_pacific}
\alias{ec_flag_non_east_pacific}
\title{Flag occurrences those are not in east Pacific and are inland}
\usage{
ec_flag_non_east_pacific(
  ocean_names,
  buffer_distance = 50000,
  data,
  latitude = "decimalLatitude",
  longitude = "decimalLongitude"
)
}
\arguments{
\item{ocean_names, }{Insert the name of oceans:
"South Pacific Ocean", "North Pacific Ocean", North Atlantic Ocean", "South Atlantic Ocean"}

\item{buffer_distance, }{Its a certain buffer distance to consider if a data point is inland. Beyond this distance data points consider as bad data points. e.g. buffer_distance <- 25000}

\item{data, }{Data table which has latitude and longitude information}

\item{latitude}{default set to "decimalLatitude"}

\item{longitude}{default set to "decimalLongitude"}
}
\value{
A new column with flagged values, 1 means bad records 0 means good record. Column name: flag_non_region
}
\description{
Flag occurrences those are not in east Pacific and are inland
}
\examples{
\dontrun{
ocean_names <- c("North Pacific Ocean", "South Pacific Ocean")
buffer_distance <- 25000
data <- data.frame(
  species = "A",
  decimalLongitude = c(-120, -78, -110),
  decimalLatitude = c(20, 34, 30)
)
data$flag_non_region <- ec_flag_non_east_pacific(
  ocean_names,
  buffer_distance,
  data,
  latitude = "decimalLatitude",
  longitude = "decimalLongitude"
)
}
}
