% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R, R/s3_funcs.R
\name{predict.emc.prior}
\alias{predict.emc.prior}
\alias{predict.emc}
\title{Generate Posterior/Prior Predictives}
\usage{
\method{predict}{emc.prior}(object, data = NULL, n_post = 50, n_cores = 1, n_trials = NULL, ...)

\method{predict}{emc}(
  object,
  hyper = FALSE,
  n_post = 50,
  n_cores = 1,
  stat = c("random", "mean", "median")[1],
  ...
)
}
\arguments{
\item{object}{An emc or emc.prior object from which to generate predictives}

\item{data}{A data frame needed to exactly match the original design}

\item{n_post}{Integer. Number of generated datasets}

\item{n_cores}{Integer. Number of cores across which there should be parallellized}

\item{n_trials}{An integer. If \code{data} isn't provided (although preferred),
can generate data based on \code{n_trials} per cell of \code{design}}

\item{...}{Optional additional arguments passed to \code{get_pars} or \code{make_data}}

\item{hyper}{Boolean. Defaults to \code{FALSE}. If \code{TRUE}, simulates from the group-level (\code{hyper})
parameters instead of the subject-level parameters.}

\item{stat}{Character. Can be \code{mean}, \code{median} or \code{random} (i.e., the default).
Will take either random samples from the chain(s) or use the mean or median of the parameter estimates.}
}
\value{
A list of simulated data sets of length \code{n_post}
}
\description{
Simulate \code{n_post} data sets using the posterior/prior parameter estimates
}
\examples{
\donttest{
# based on an emc object ran by fit() we can generate posterior predictives
predict(samples_LNR, n_cores = 1, n_post = 10)
}
}
