% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_parts.R
\name{predict_parts}
\alias{predict_parts}
\alias{predict_parts_break_down}
\alias{predict_parts_ibreak_down}
\alias{predict_parts_shap}
\alias{predict_parts_oscillations}
\alias{predict_parts_oscillations_uni}
\alias{predict_parts_oscillations_emp}
\alias{predict_parts_break_down_interactions}
\alias{predict_parts_shap_aggregated}
\alias{variable_attribution}
\title{Instance Level Parts of the Model Predictions}
\usage{
predict_parts(
  explainer,
  new_observation,
  ...,
  N = if (substr(type, 1, 4) == "osci") 500 else NULL,
  type = "break_down"
)

predict_parts_oscillations(explainer, new_observation, ...)

predict_parts_oscillations_uni(
  explainer,
  new_observation,
  variable_splits_type = "uniform",
  ...
)

predict_parts_oscillations_emp(
  explainer,
  new_observation,
  variable_splits = NULL,
  variables = colnames(explainer$data),
  ...
)

predict_parts_break_down(explainer, new_observation, ...)

predict_parts_break_down_interactions(explainer, new_observation, ...)

predict_parts_shap(explainer, new_observation, ...)

predict_parts_shap_aggregated(explainer, new_observation, ...)

variable_attribution(
  explainer,
  new_observation,
  ...,
  N = if (substr(type, 1, 4) == "osci") 500 else NULL,
  type = "break_down"
)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by the \code{explain} function}

\item{new_observation}{a new observation for which predictions need to be explained}

\item{...}{other parameters that will be passed to \code{iBreakDown::break_down}}

\item{N}{the maximum number of observations used for calculation of attributions. By default NULL (use all) or 500 (for oscillations).}

\item{type}{the type of variable attributions. Either \code{shap}, \code{aggregated_shap}, \code{oscillations}, \code{oscillations_uni},
\code{oscillations_emp}, \code{break_down} or \code{break_down_interactions}.}

\item{variable_splits_type}{how variable grids shall be calculated? Will be passed to \code{\link[ingredients]{ceteris_paribus}}.}

\item{variable_splits}{named list of splits for variables. It is used by oscillations based measures. Will be passed to \code{\link[ingredients]{ceteris_paribus}}.}

\item{variables}{names of variables for which splits shall be calculated. Will be passed to \code{\link[ingredients]{ceteris_paribus}}.}
}
\value{
Depending on the \code{type} there are different classes of the resulting object.
It's a data frame with calculated average response.
}
\description{
Instance Level Variable Attributions as Break Down, SHAP, aggregated SHAP or Oscillations explanations.
Model prediction is decomposed into parts that are attributed for particular variables.
From DALEX version 1.0 this function calls the \code{\link[iBreakDown]{break_down}} or
\code{\link[iBreakDown:break_down_uncertainty]{shap}} functions from the \code{iBreakDown} package or
\code{\link[ingredients:ceteris_paribus]{ceteris_paribus}} from the \code{ingredients} package.
Find information how to use the \code{break_down} method here: \url{https://ema.drwhy.ai/breakDown.html}.
Find information how to use the \code{shap} method here: \url{https://ema.drwhy.ai/shapley.html}.
Find information how to use the \code{oscillations} method here: \url{https://ema.drwhy.ai/ceterisParibusOscillations.html}.
aSHAP method provides explanations for a set of observations based on SHAP.
}
\examples{
library(DALEX)

new_dragon <- data.frame(
    year_of_birth = 200,
    height = 80,
    weight = 12.5,
    scars = 0,
    number_of_lost_teeth  = 5
)

model_lm <- lm(life_length ~ year_of_birth + height +
               weight + scars + number_of_lost_teeth,
               data = dragons)

explainer_lm <- explain(model_lm,
                        data = dragons,
                        y = dragons$year_of_birth,
                        label = "model_lm")

bd_lm <- predict_parts_break_down(explainer_lm, new_observation = new_dragon)
head(bd_lm)
plot(bd_lm)

\donttest{
library("ranger")
model_ranger <- ranger(life_length ~ year_of_birth + height +
                       weight + scars + number_of_lost_teeth,
                       data = dragons, num.trees = 50)

explainer_ranger <- explain(model_ranger,
                            data = dragons,
                            y = dragons$year_of_birth,
                            label = "model_ranger")

bd_ranger <- predict_parts_break_down(explainer_ranger, new_observation = new_dragon)
head(bd_ranger)
plot(bd_ranger)
}

}
\references{
Explanatory Model Analysis. Explore, Explain, and Examine Predictive Models. \url{https://ema.drwhy.ai/}
}
