% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_common_functions.R
\name{print.Coxmos}
\alias{print.Coxmos}
\title{print.Coxmos}
\usage{
\method{print}{Coxmos}(x, ...)
}
\arguments{
\item{x}{Coxmos object}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Print information relative to a Coxmos object.
}
\description{
Provides a structured print output for objects of class Coxmos, detailing either the
final Cox survival model or the attributes of the optimal model from cross-validation.
}
\details{
The \code{print.Coxmos} function serves as a diagnostic tool, offering a comprehensive display
of the Coxmos object's attributes. Depending on the nature of the Coxmos object—whether it's derived
from a survival model or a cross-validated model—the function tailors its output accordingly. For
survival models, it elucidates the method employed, any variables removed due to high correlation,
zero or near-zero variance, or non-significance within the Cox model, and presents a summary of
the survival model itself. In the context of cross-validated models, the function delineates the
cross-validation method utilized and, if ascertainable, details of the best model. For evaluation
objects, it systematically enumerates the methods evaluated and provides a summary of metrics for
each method.
}
\examples{
data("X_proteomic")
data("Y_proteomic")
X <- X_proteomic[,1:50]
Y <- Y_proteomic
model <- splsicox(X, Y, x.center = TRUE, x.scale = TRUE)
print(model)
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
