% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BasicRun.R
\name{LikelihoodBound.poisres}
\alias{LikelihoodBound.poisres}
\title{Calculates the likelihood boundary for a completed Poisson model}
\usage{
\method{LikelihoodBound}{poisres}(x, df, curve_control = list(), control = list(), ...)
}
\arguments{
\item{x}{result object from a regression, class poisres}

\item{df}{a data.table containing the columns of interest}

\item{curve_control}{a list of control options for the likelihood boundary regression. See the Control_Options vignette for details.}

\item{control}{list of parameters controlling the convergence, see the Control_Options vignette for details}

\item{...}{can include the named entries for the curve_control list parameter}
}
\value{
returns a list of the final results
}
\description{
\code{LikelihoodBound.poisres} solves the confidence interval for a Poisson model, starting at the optimum point and
iteratively optimizing end-points of intervals.
}
\seealso{
Other Poisson Wrapper Functions: 
\code{\link{EventAssignment.poisres}()},
\code{\link{EventAssignment.poisresbound}()},
\code{\link{PoisRun}()},
\code{\link{PoisRunJoint}()},
\code{\link{PoisRunMulti}()},
\code{\link{Residual.poisres}()}
}
\concept{Poisson Wrapper Functions}
