% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_cpg_annot.R
\name{get_cpg_annotation}
\alias{get_cpg_annotation}
\title{Get CpG annotation from Illumina}
\usage{
get_cpg_annotation(
  cpg_id,
  is_epic = TRUE,
  short_annotation = TRUE,
  silence_warnings = TRUE
)
}
\arguments{
\item{cpg_id}{A character vector with the CpG IDs from Illumina to annotate.}

\item{is_epic}{A boolean, if TRUE, the annotation will be fetched from the EPIC array, otherwise from the 450k array. Default is TRUE.}

\item{short_annotation}{A boolean, if TRUE, only a small number of columns from the full annotation reference will be kept. This leads to an easier to read output. Default is TRUE.}

\item{silence_warnings}{A boolean, if TRUE, warnings produced during the downloading and loading of the data will be silenced. Default is TRUE.}
}
\value{
A table with the annotated CpGs in the same order as the provided signatures.
}
\description{
Get CpG annotation from Illumina
}
\examples{
\donttest{
library("CimpleG")

# read data
signatures <- c("cg14501977", "cg24548498")

# Get signature annotation
signature_annotation <- get_cpg_annotation(signatures)

# check signature annotation
signature_annotation
}
}
