% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitialEstimateClass.R
\name{InitialEstimate}
\alias{InitialEstimate}
\title{Create an object of class InitialEstimate}
\usage{
InitialEstimate(Initial = numeric(), ...)
}
\arguments{
\item{Initial}{Numeric. Initial estimate for the model parameter.}

\item{...}{Additional initial estimate(s) for the model parameter.}
}
\value{
An object of class \code{InitialEstimate}.
}
\description{
This function creates an object of class \code{InitialEstimate} that contains
initial parameter estimates for a model \code{\link[=Theta]{Theta()}}. The estimates can be
passed to the function as a single numeric value or as a vector of length
three containing lower bound, estimate, and upper bound. If multiple sets of
estimates are required, they can be passed as additional arguments, each
separated by commas.
}
\examples{
InitialEstimate(1)
InitialEstimate(c(0, 1, Inf), c(-Inf, 2, 10))

}
\seealso{
Functions used for Theta specification: 
\code{\link{Theta}()},
\code{\link{create_ModelPD}()},
\code{\link{create_ModelPK}()},
\code{\link{modify_Theta}()}
}
\concept{Thetas}
