% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RegressionModel.R
\name{CoxModel}
\alias{CoxModel}
\title{Cox-Beta Model for Case-Based-Reasoning}
\description{
Cox-Beta Model for Case-Based-Reasoning

Cox-Beta Model for Case-Based-Reasoning
}
\details{
Regression beta coefficients obtained from a CPH regression model fitted on the 
training data are used for building a weighted distance measure between
train and test data. Afterwards, we will use these weights for calculating a 
(n x m)-distance matrix, where n is the number of observations in the training data, 
and m is the number of observations of the test data. The user can use this 
distance matrix for further cluster analysis or for extracting for each test observation 
k (= 1,...,l) similar cases from the train data. We use the rms-package for model fitting,
variable selection, and checking model assumptions.
If the user omits the test data, this functions returns a n x n-distance matrix.
}
\section{Super classes}{
\code{\link[CaseBasedReasoning:CBRBase]{CaseBasedReasoning::CBRBase}} -> \code{\link[CaseBasedReasoning:RegressionModel]{CaseBasedReasoning::RegressionModel}} -> \code{CoxModel}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{model}}{the statistical model}

\item{\code{model_params}}{rms arguments}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CoxModel-check_ph}{\code{CoxModel$check_ph()}}
\item \href{#method-CoxModel-clone}{\code{CoxModel$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="CaseBasedReasoning" data-topic="CBRBase" data-id="calc_distance_matrix"><a href='../../CaseBasedReasoning/html/CBRBase.html#method-CBRBase-calc_distance_matrix'><code>CaseBasedReasoning::CBRBase$calc_distance_matrix()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CaseBasedReasoning" data-topic="CBRBase" data-id="get_similar_cases"><a href='../../CaseBasedReasoning/html/CBRBase.html#method-CBRBase-get_similar_cases'><code>CaseBasedReasoning::CBRBase$get_similar_cases()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CaseBasedReasoning" data-topic="CBRBase" data-id="initialize"><a href='../../CaseBasedReasoning/html/CBRBase.html#method-CBRBase-initialize'><code>CaseBasedReasoning::CBRBase$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CaseBasedReasoning" data-topic="RegressionModel" data-id="fit"><a href='../../CaseBasedReasoning/html/RegressionModel.html#method-RegressionModel-fit'><code>CaseBasedReasoning::RegressionModel$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CaseBasedReasoning" data-topic="RegressionModel" data-id="print"><a href='../../CaseBasedReasoning/html/RegressionModel.html#method-RegressionModel-print'><code>CaseBasedReasoning::RegressionModel$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CaseBasedReasoning" data-topic="RegressionModel" data-id="variable_selection"><a href='../../CaseBasedReasoning/html/RegressionModel.html#method-RegressionModel-variable_selection'><code>CaseBasedReasoning::RegressionModel$variable_selection()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CoxModel-check_ph"></a>}}
\if{latex}{\out{\hypertarget{method-CoxModel-check_ph}{}}}
\subsection{Method \code{check_ph()}}{
Check proportional hazard assumption graphically
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CoxModel$check_ph()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CoxModel-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CoxModel-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CoxModel$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
