% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProbabilityFunctions.R
\name{sim_Vn}
\alias{sim_Vn}
\title{CUSUM Statistic Simulation (Assuming Variance)}
\usage{
sim_Vn(size, n = 500, gen_func = rnorm, sd = 1, args = NULL)
}
\arguments{
\item{size}{Number of realizations to simulate}

\item{n}{The sample size for each realization}

\item{gen_func}{The function generating the random sample from which the
statistic is computed}

\item{sd}{The square root of the second moment of the data}

\item{args}{A list of arguments to be passed to \code{gen_func}}
}
\value{
A vector of simulated realizations of the CUSUM statistic
}
\description{
Simulates multiple realizations of the CUSUM statistic when the long-run
variance of the data is known.
}
\examples{
CPAT:::sim_Vn(100)
CPAT:::sim_Vn(100, gen_func = CPAT:::rchangepoint,
              args = list(changepoint = 250, mean2 = 1))
}
