% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChangePointTests.R
\name{CUSUM.test}
\alias{CUSUM.test}
\title{CUSUM Test}
\usage{
CUSUM.test(x, use_kernel_var = FALSE, stat_plot = FALSE,
  kernel = "ba", bandwidth = "and")
}
\arguments{
\item{x}{Data to test for change in mean}

\item{use_kernel_var}{Set to \code{TRUE} to use kernel methods for long-run
variance estimation (typically used when the data is
believed to be correlated); if \code{FALSE}, then the
long-run variance is estimated using
\eqn{\hat{\sigma}^2_{T,t} = T^{-1}\left(
\sum_{s = 1}^t \left(X_s - \bar{X}_t\right)^2 +
\sum_{s = t + 1}^{T}\left(X_s -
\tilde{X}_{T - t}\right)^2\right)}, where
\eqn{\bar{X}_t = t^{-1}\sum_{s = 1}^t X_s} and
\eqn{\tilde{X}_{T - t} = (T - t)^{-1}
\sum_{s = t + 1}^{T} X_s}}

\item{stat_plot}{Whether to create a plot of the values of the statistic at
all potential change points}

\item{kernel}{If character, the identifier of the kernel function as used in
\pkg{cointReg} (see \code{\link[cointReg]{getLongRunVar}}); if
function, the kernel function to be used for long-run variance
estimation (default is the Bartlett kernel in \pkg{cointReg})}

\item{bandwidth}{If character, the identifier for how to compute the
bandwidth as defined in \pkg{cointReg} (see
\code{\link[cointReg]{getBandwidth}}); if function, a function
to use for computing the bandwidth; if numeric, the bandwidth
value to use (the default is to use Andrews' method, as used in
\pkg{cointReg})}
}
\value{
A \code{htest}-class object containing the results of the test
}
\description{
Performs the (univariate) CUSUM test for change in mean, as described in
\insertCite{horvathricemiller19}{CPAT}. This is effectively an interface to
\code{\link{stat_Vn}}; see its documentation for more details. p-values are
computed using \code{\link{pkolmogorov}}, which represents the limiting
distribution of the statistic under the null hypothesis.
}
\examples{
CUSUM.test(rnorm(1000))
CUSUM.test(rnorm(1000), use_kernel_var = TRUE, kernel = "bo",
           bandwidth = "nw")
}
\references{
\insertAllCited{}
}
