% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{BTsubset_meta}
\alias{BTsubset_meta}
\title{BioTIME subset metadata}
\format{
## `BTsubset_meta`
A data frame with 12 rows and 25 columns:
\describe{
  \item{STUDY_ID}{BioTIME study unique identifier}
  \item{REALM}{Realm of study location, i.e. Marine}
  \item{CLIMATE}{Climate of study location, i.e. Temperate}
  \item{HABITAT}{Habitat of study location, i.e. Rivers}
  \item{PROTECTED_AREA}{Binary variable indicating if the study is within a protected area}
  \item{BIOME_MAP}{Biome of study location (taken from the WWF biomes, i.e. Temperate broadleaf and mixed forests}
  \item{TAXA}{High level taxonomic identity of study species, i.e. Fish}
  \item{ORGANISMS}{More detailed information on taxonomy, i.e. woody plants}
  \item{TITLE}{Title of study as identified in original source}
  \item{AB_BIO}{A, B or AB to designate abundance only, biomass only or both}
  \item{DATA_POINTS}{Number of unique data points in study, e.g. 10 data points spanning 15 years = 10}
  \item{START_YEAR}{First year of study}
  \item{END_YEAR}{Last year of study}
  \item{CENT_LAT}{Central latitude taken from the convex hull around all study coordinates}
  \item{CENT_LONG}{Central longitude taken from the convex hull around all study coordinates}
  \item{NUMBER_OF_SPECIES}{Number of distinct species in study}
  \item{NUMBER_OF_SAMPLES}{Number of distinct samples in study}
  \item{NUMBER_LAT_LONG}{Number of distinct geographic coordinates in study}
  \item{TOTAL}{Total number of records in study}
  \item{GRAIN_SIZE_TEXT}{Grain size described in text, i.e. size of forest plots}
  \item{AREA_SQ_KM}{Total area of study in km2}
  \item{DATE_STUDY_ADDED}{Date that the study was added to the database}
  \item{ABUNDANCE_TYPE}{Type of abundance, i.e. count}
  \item{BIOMASS_TYPE}{Type of biomass, i.e. weight}
  \item{SAMPLE_DESC}{Concatenation of descriptors comprising the unique sampling event}
}
}
\source{
<https://biotime.st-andrews.ac.uk/download.php>
}
\usage{
BTsubset_meta
}
\description{
A subset of the metadata from BioTIME
}
\keyword{datasets}
