% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getsnp.R
\name{getsnp}
\alias{getsnp}
\title{Read SNP data from a binary dosage file}
\usage{
getsnp(bdinfo, snp, dosageonly = TRUE)
}
\arguments{
\item{bdinfo}{Information about a binary dosage file return
from getbdinfo}

\item{snp}{The SNP to read the information about. This may
be the SNP ID or the index of the SNP in the snps dataset in
the bdinfo list}

\item{dosageonly}{Indicator to return the dosages only or the
dosages allowing with the genetic probabilities.
Default value is TRUE}
}
\value{
A list with either the dosages or the dosages and the genetic
probabilities.
}
\description{
Routine to read the dosage and genetic probabilities about
a SNP from a binary dosage file
}
\examples{
# Get the information about the file
vcf1abdfile <- system.file("extdata", "vcf1a.bdose", package = "BinaryDosage")
bdinfo <- getbdinfo(bdfiles = vcf1abdfile)

# Read the first SNP
getsnp(bdinfo, 1, FALSE)
}
