% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBeeGUTS.R
\name{traceplot}
\alias{traceplot}
\alias{traceplot.beeSurvFit}
\title{Plotting method for traces and densities for \code{beeSurvFit} objects}
\usage{
traceplot(object, ..., incWarmup_trace = TRUE, incWarmup_dens = FALSE)

\method{traceplot}{beeSurvFit}(object, ..., incWarmup_trace = TRUE, incWarmup_dens = FALSE)
}
\arguments{
\item{object}{An object of class \code{beeSurvFit} to be plotted}

\item{...}{Additional parameters to be parsed to generic \code{rstan} plot functions}

\item{incWarmup_trace}{A logical indicating whether the warmup iterations should be plotted
in the traceplot (default TRUE)}

\item{incWarmup_dens}{A logical indicating whether the warmup iterations should be plotted
in the density plot (default FALSE)}
}
\value{
A graphic with the traceplots and densities of the fit
}
\description{
This is the generic \code{traceplot} S3 method for the \code{beeSurvFit}
class. It plots the traces with as well as the densities for the parameters of
the GUTS IT or GUTS SD. The traceplot includes by default the warmup iterations,
the density plot does not include them
}
\examples{
data(fitBetacyfluthrin_Chronic)
traceplot(fitBetacyfluthrin_Chronic)
}
