/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Statistic;
import dr.inference.operators.factorAnalysis.FactorAnalysisOperatorAdaptor;
import dr.inference.operators.factorAnalysis.FactorAnalysisStatisticsProvider;
import dr.inferencexml.operators.factorAnalysis.LoadingsOperatorParserUtilities;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class FactorProportionStatistic
extends Statistic.Abstract {
    private final FactorAnalysisOperatorAdaptor adaptor;
    private final FactorAnalysisStatisticsProvider statisticsProvider;
    private final double[] relativeFactorProportions;
    private final double[] absoluteFactorProportions;
    private double relativeMarginalProportion;
    private double factorProportion;
    private static final String FACTOR_PROPORTION = "factorProportionStatistic";
    public static AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            FactorAnalysisOperatorAdaptor factorAnalysisOperatorAdaptor = LoadingsOperatorParserUtilities.parseFactorAnalsysisOperatorAdaptor((XMLObject)xMLObject);
            return new FactorProportionStatistic(factorAnalysisOperatorAdaptor);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return LoadingsOperatorParserUtilities.adaptorRules;
        }

        @Override
        public String getParserDescription() {
            return "Absolute and relative contribution of each factor to the variance in the data";
        }

        @Override
        public Class getReturnType() {
            return FactorProportionStatistic.class;
        }

        @Override
        public String getParserName() {
            return FactorProportionStatistic.FACTOR_PROPORTION;
        }
    };

    FactorProportionStatistic(FactorAnalysisOperatorAdaptor factorAnalysisOperatorAdaptor) {
        this.adaptor = factorAnalysisOperatorAdaptor;
        this.statisticsProvider = new FactorAnalysisStatisticsProvider(factorAnalysisOperatorAdaptor, FactorAnalysisStatisticsProvider.CacheProvider.NO_CACHE);
        int n = factorAnalysisOperatorAdaptor.getNumberOfFactors();
        this.relativeFactorProportions = new double[n];
        this.absoluteFactorProportions = new double[n];
    }

    @Override
    public int getDimension() {
        int n = this.adaptor.getNumberOfFactors();
        return 2 * n + 2;
    }

    @Override
    public double getStatisticValue(int n) {
        int n2 = this.adaptor.getNumberOfFactors();
        if (n == 0) {
            this.computeStatistics();
        }
        if (n == 0) {
            return this.factorProportion;
        }
        if (n < n2 + 1) {
            return this.absoluteFactorProportions[n - 1];
        }
        if (n < 2 * n2 + 1) {
            return this.relativeFactorProportions[n - (n2 + 1)];
        }
        if (n == this.getDimension() - 1) {
            return this.relativeMarginalProportion;
        }
        throw new RuntimeException("Unknown dimension: " + n);
    }

    @Override
    public String getDimensionName(int n) {
        String string;
        int n2 = this.adaptor.getNumberOfFactors();
        if (n == 0) {
            string = "factorProportion";
        } else if (n < n2 + 1) {
            string = "absoluteProportion." + n;
        } else if (n < 2 * n2 + 1) {
            string = "relativeProportion." + (n - n2);
        } else if (n == this.getDimension() - 1) {
            string = "relativeMarginalProportion";
        } else {
            throw new RuntimeException("Unknown dimension: " + n);
        }
        return this.getStatisticName() + "." + string;
    }

    private void computeStatistics() {
        int n = this.adaptor.getNumberOfFactors();
        int n2 = this.adaptor.getNumberOfTaxa();
        int n3 = this.adaptor.getNumberOfTraits();
        this.adaptor.drawFactors();
        double[][] dArray = new double[n][n];
        this.statisticsProvider.getFactorInnerProduct(-1, n, dArray, false);
        double[][] dArray2 = new double[n][n];
        this.statisticsProvider.getLoadingsInnerProduct(dArray2);
        double[] dArray3 = new double[n];
        this.statisticsProvider.getFactorMeans(dArray3);
        double[][] dArray4 = new double[n][n];
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                double d3;
                dArray4[i][j] = d3 = dArray2[i][j] * (dArray[i][j] - (double)n2 * dArray3[i] * dArray3[j]);
                d += d3;
                if (i != j) {
                    dArray4[j][i] = d3;
                    d += d3;
                    continue;
                }
                d2 += d3;
            }
        }
        double d4 = 0.0;
        for (int i = 0; i < n3; ++i) {
            d4 += 1.0 / this.adaptor.getColumnPrecision(i);
        }
        double d5 = d + (d4 *= (double)(n2 - 1));
        this.factorProportion = d / d5;
        this.relativeMarginalProportion = d2 / d;
        for (int i = 0; i < n; ++i) {
            this.relativeFactorProportions[i] = dArray4[i][i] / d;
            this.absoluteFactorProportions[i] = dArray4[i][i] / d5;
        }
    }
}

