% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BF_users_functions.r
\name{BFpower.f}
\alias{BFpower.f}
\title{Sample size determination for Bayesian F-test}
\usage{
BFpower.f(
  interval = NULL,
  D = NULL,
  target = NULL,
  FP = NULL,
  p = NULL,
  k = NULL,
  model = NULL,
  dff = NULL,
  rscale = NULL,
  f_m = NULL,
  model_d = NULL,
  dff_d = NULL,
  rscale_d = NULL,
  f_m_d = NULL,
  de_an_prior = NULL,
  N = NULL,
  mode_bf = NULL,
  direct = NULL,
  e = NULL
)
}
\arguments{
\item{interval}{Character or integer (0 or 1). If \code{"1"}, Bayes factor with a point null against a composite alternative hypothesis;
otherwise Bayes factor with interval null and alternative hypotheses.}

\item{D}{The bound of compelling evidence.}

\item{target}{The targeted true positive rate (if \code{direct = "h1"}) or true negative rate (if \code{direct = "h0"}).}

\item{FP}{The targeted false positive rate (if \code{direct = "h1"}) or false negative rate (if \code{direct = "h0"}).}

\item{p}{Number of predictors in the reduced model.}

\item{k}{Number of predictors in the full model.}

\item{model}{Statistical model of the analysis prior under the alternative hypothesis: effect size prior  (\code{"effectsize"}) or Moment prior (\code{"Moment"})}

\item{dff}{Degrees of freedom for the analysis prior under the alternative hypothesis.(must be >3 if moment prior is used)}

\item{rscale}{Scaling parameter for the analysis effect size prior.}

\item{f_m}{Cohen's f effect size parameter for the analysis prior.}

\item{model_d}{Statistical model of the design prior under the alternative hypothesis:: effect size prior  (\code{"effectsize"}), Moment prior (\code{"Moment"}), or Point prior (\code{"Point"})}

\item{dff_d}{Degrees of freedom for the design prior under the alternative hypothesis. (must be >3 if moment prior is used)}

\item{rscale_d}{Scaling parameter for the design effect size prior.}

\item{f_m_d}{Cohen's f effect size parameter for the design prior or the point design prior.}

\item{de_an_prior}{Integer (0 or 1). If 1, analysis and design priors under the alternative are the same; if 0, they are not.}

\item{N}{Sample size.}

\item{mode_bf}{Integer (0 or 1). If \code{1}, sample size determination; if \code{2}, \code{N} is needed for the calculation of probabilities of compelling and misleading evidence.}

\item{direct}{If \code{"h1"}, BF10; if \code{"h0"}, BF01.}

\item{e}{The bounds for the interval Bayes factor (used when \code{interval = 0}).}
}
\value{
A data frame with the following columns:
\itemize{
\item \code{p(BF10 > D | H1)}: Probability of obtaining compelling evidence
in favor of the alternative hypothesis when the alternative is true.
\item \code{p(BF01 > D | H1)}: Probability of obtaining misleading evidence
in favor of the null hypothesis when the alternative is true.
\item \code{p(BF01 > D | H0)}: Probability of obtaining compelling evidence
in favor of the null hypothesis when the null is true.
\item \code{p(BF10 > D | H0)}: Probability of obtaining misleading evidence
in favor of the alternative hypothesis when the null is true.
\item \code{Required N}: The required sample size or the sample size input by the users.
}
If sample size determination fails, the function returns \code{NULL}.
}
\description{
Perform sample size determination or the calculation of compelling and misleading evidence
for a Bayesian F-test.
}
\examples{
BFpower.f(
 inter = "1",
 D = 3,
 target = 0.8,
 p = 1,
 k = 2,
 model = "Moment",
 dff = 1,
 f_m = 0.1,
 de_an_prior = 1,
 mode_bf = 1,
 direct = "h1"
)

}
