% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustCpObj.R
\name{plot.ClustCpObj}
\alias{plot.ClustCpObj}
\title{Plot estimated partition}
\usage{
\method{plot}{ClustCpObj}(
  x,
  y = NULL,
  loss = "VI",
  maxNClusters = 0,
  nRuns = 16,
  maxZealousAttempts = 10,
  ...
)
}
\arguments{
\item{x}{an object of class \code{ClustCpObj}.}

\item{y}{parameter of the generic method.}

\item{loss}{The loss function used to estimate the final partition, it can be "VI", "binder", "omARI", "NVI", "ID", "NID".}

\item{maxNClusters}{maximum number of clusters in salso procedure.}

\item{nRuns}{number of runs in salso procedure.}

\item{maxZealousAttempts}{maximum number of zealous attempts in salso procedure.}

\item{...}{parameter of the generic method.}
}
\value{
The function returns a ggplot object representing the time series or the epidemic diffusions colored according to the final partition.
}
\description{
The \code{plot} method plots the estimates partition through the salso algorithm, for a \code{ClustCpObj} class object.
}
\examples{

\donttest{
## Time series

data_mat <- matrix(NA, nrow = 5, ncol = 100)

data_mat[1,] <- as.numeric(c(rnorm(50,0,0.100), rnorm(50,1,0.250)))
data_mat[2,] <- as.numeric(c(rnorm(50,0,0.125), rnorm(50,1,0.225)))
data_mat[3,] <- as.numeric(c(rnorm(50,0,0.175), rnorm(50,1,0.280)))
data_mat[4,] <- as.numeric(c(rnorm(25,0,0.135), rnorm(75,1,0.225)))
data_mat[5,] <- as.numeric(c(rnorm(25,0,0.155), rnorm(75,1,0.280)))

out <- clust_cp(data = data_mat, n_iterations = 5000, n_burnin = 1000,
                params = list(L = 1, B = 1000, phi = 0.5), kernel = "ts")

plot(out)


## Epidemic diffusions

data_mat <- matrix(NA, nrow = 5, ncol = 50)

betas <- list(c(rep(0.45, 25),rep(0.14,25)),
              c(rep(0.55, 25),rep(0.11,25)),
              c(rep(0.50, 25),rep(0.12,25)),
              c(rep(0.52, 10),rep(0.15,40)),
              c(rep(0.53, 10),rep(0.13,40)))

inf_times <- list()

for(i in 1:5){
  inf_times[[i]] <- sim_epi_data(10000, 10, 50, betas[[i]], 1/8)
  vec <- rep(0,50)
  names(vec) <- as.character(1:50)
  for(j in 1:50){
    if(as.character(j) \%in\% names(table(floor(inf_times[[i]])))){
      vec[j] = table(floor(inf_times[[i]]))[which(names(table(floor(inf_times[[i]]))) == j)]
    }
  }
  data_mat[i,] <- vec
}

out <- clust_cp(data = data_mat, n_iterations = 100, n_burnin = 10,
                params = list(M = 100, L = 1, B = 100), kernel = "epi")

plot(out)
}

}
