% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.kclustering.R
\name{plot.kclustering}
\alias{plot.kclustering}
\title{Plot k-means clustering from a 'kclustering' object}
\usage{
\method{plot}{kclustering}(
  x,
  title = NULL,
  ncol.arrange = NULL,
  min.mid.max = NULL,
  label.size = 2.5,
  ...
)
}
\arguments{
\item{x}{an object of class \code{kclustering}.}

\item{title}{character or vector of characters (when plotting radial plots of cluster profiles; see Value), plot title(s).}

\item{ncol.arrange}{integer, number of columns when arranging multiple grobs on a page (active when plotting radial plots of cluster profiles; see Value).}

\item{min.mid.max}{numeric vector with 3 elements: lower bound, middle dashed line, upper bound for radial axis (active when plotting radial plots of cluster profiles; see Value).}

\item{label.size}{numeric; label font size (default 2.5).}

\item{...}{other graphical parameters.}
}
\value{
If \code{x$k} is \code{NULL}, \code{plot.kclustering} returns a single \code{ggplot2} object, displaying the pattern of the explained variance vs the number of clusters.

If \code{x$k} is not \code{NULL}, \code{plot.kclustering} returns a list of \code{ggplot2} objects, displaying the radial plots of the cluster profiles.
}
\description{
Plot k-means clustering from a 'kclustering' object
}
\examples{
FF <- fourfactors(Tbox,Obox)
X <- with(FF, data.frame(OD.Rtg=ORtg/DRtg,
               F1.r=F1.Def/F1.Off, F2.r=F2.Off/F2.Def,
               F3.O=F3.Def, F3.D=F3.Off))
X$P3M <- Tbox$P3M
X$STL.r <- Tbox$STL/Obox$STL
kclu1 <- kclustering(X)
plot(kclu1)
kclu2 <- kclustering(X, k=9)
plot(kclu2)
}
\references{
P. Zuccolotto and M. Manisera (2020) Basketball Data Science: With Applications in R. CRC Press.
}
\seealso{
\code{\link{kclustering}}, \code{\link{radialprofile}}
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{basketballanalyzer.help@unibs.it})
}
