% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{Plot.Line}
\alias{Plot.Line}
\title{Plot.Line}
\usage{
Plot.Line(
  dt = NULL,
  AggMethod = "mean",
  PreAgg = TRUE,
  XVar = NULL,
  YVar = NULL,
  DualYVar = NULL,
  GroupVar = NULL,
  YVarTrans = "Identity",
  DualYVarTrans = "Identity",
  XVarTrans = "Identity",
  FacetRows = 1,
  FacetCols = 1,
  FacetLevels = NULL,
  Height = NULL,
  Width = NULL,
  Title = "Line Plot",
  ShowLabels = FALSE,
  Title.YAxis = NULL,
  Title.XAxis = NULL,
  EchartsTheme = "macarons",
  MouseScroll = TRUE,
  TimeLine = TRUE,
  Area = FALSE,
  Alpha = 0.5,
  Smooth = TRUE,
  ShowSymbol = FALSE,
  TextColor = "white",
  title.fontSize = 22,
  title.fontWeight = "bold",
  title.textShadowColor = "#63aeff",
  title.textShadowBlur = 3,
  title.textShadowOffsetY = 1,
  title.textShadowOffsetX = -1,
  xaxis.fontSize = 14,
  yaxis.fontSize = 14,
  xaxis.rotate = 0,
  yaxis.rotate = 0,
  ContainLabel = TRUE,
  DarkMode = FALSE,
  Debug = FALSE
)
}
\arguments{
\item{dt}{source data.table}

\item{AggMethod}{character}

\item{PreAgg}{logical}

\item{XVar}{X-Axis variable name}

\item{YVar}{Y-Axis variable name. You can supply multiple YVars}

\item{DualYVar}{Secondary Y-Axis variables. Leave NULL for no secondary axis. Only one variable is allowed and when this is set only one YVar is allowed. An error will be thrown if those conditions are not met}

\item{GroupVar}{One Grouping Variable}

\item{YVarTrans}{"Asinh", "Log", "LogPlus1", "Sqrt", "Asin", "Logit", "PercRank", "Standardize", "BoxCox", "YeoJohnson"}

\item{DualYVarTrans}{"Asinh", "Log", "LogPlus1", "Sqrt", "Asin", "Logit", "PercRank", "Standardize", "BoxCox", "YeoJohnson"}

\item{XVarTrans}{"Asinh", "Log", "LogPlus1", "Sqrt", "Asin", "Logit", "PercRank", "Standardize", "BoxCox", "YeoJohnson"}

\item{FacetRows}{Defaults to 1 which causes no faceting to occur vertically. Otherwise, supply a numeric value for the number of output grid rows}

\item{FacetCols}{Defaults to 1 which causes no faceting to occur horizontally. Otherwise, supply a numeric value for the number of output grid columns}

\item{FacetLevels}{Faceting rows x columns is the max number of levels allowed in a grid. If your GroupVar has more you can supply the levels to display.}

\item{Height}{NULL}

\item{Width}{NULL}

\item{Title}{"Title"}

\item{ShowLabels}{character}

\item{Title.YAxis}{character}

\item{Title.XAxis}{character}

\item{EchartsTheme}{Provide an "Echarts" theme}

\item{MouseScroll}{logical, zoom via mouse scroll}

\item{TimeLine}{Logical}

\item{Area}{logical}

\item{Alpha}{0 to 1 for setting transparency}

\item{Smooth}{= TRUE}

\item{ShowSymbol}{= FALSE}

\item{TextColor}{"Not Implemented"}

\item{title.fontSize}{22}

\item{title.fontWeight}{"bold"}

\item{title.textShadowColor}{'#63aeff'}

\item{title.textShadowBlur}{3}

\item{title.textShadowOffsetY}{1}

\item{title.textShadowOffsetX}{-1}

\item{xaxis.fontSize}{14}

\item{yaxis.fontSize}{14}

\item{xaxis.rotate}{0}

\item{yaxis.rotate}{0}

\item{ContainLabel}{TRUE}

\item{DarkMode}{FALSE}

\item{Debug}{Debugging purposes}
}
\value{
plot
}
\description{
This function automatically builds calibration plots and calibration boxplots for model evaluation using regression, quantile regression, and binary and multinomial classification
}
\examples{
# Create fake data
data <- AutoPlots::FakeDataGenerator(N = 1000)

# Build Line plot
AutoPlots::Plot.Line(
  dt = data,
  PreAgg = FALSE,
  AggMethod = "mean",
  XVar = "DateTime",
  YVar = "Independent_Variable3",
  YVarTrans = "LogPlus1",
  DualYVar = "Independent_Variable6",
  DualYVarTrans = "LogPlus1",
  GroupVar = NULL,
  EchartsTheme = "macarons")

}
\seealso{
Other Standard Plots: 
\code{\link{Plot.ACF}()},
\code{\link{Plot.Area}()},
\code{\link{Plot.BarPlot3D}()},
\code{\link{Plot.Bar}()},
\code{\link{Plot.Box}()},
\code{\link{Plot.Copula3D}()},
\code{\link{Plot.Copula}()},
\code{\link{Plot.CorrMatrix}()},
\code{\link{Plot.Density}()},
\code{\link{Plot.Donut}()},
\code{\link{Plot.HeatMap}()},
\code{\link{Plot.Histogram}()},
\code{\link{Plot.PACF}()},
\code{\link{Plot.Parallel}()},
\code{\link{Plot.Pie}()},
\code{\link{Plot.ProbabilityPlot}()},
\code{\link{Plot.Radar}()},
\code{\link{Plot.River}()},
\code{\link{Plot.Rosetype}()},
\code{\link{Plot.Scatter3D}()},
\code{\link{Plot.Scatter}()},
\code{\link{Plot.StackedBar}()},
\code{\link{Plot.Step}()},
\code{\link{Plot.WordCloud}()}
}
\author{
Adrian Antico
}
\concept{Standard Plots}
