% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/departureDisplays.R
\name{depDisplay}
\alias{depDisplay}
\alias{depDisplay.default}
\alias{depDisplay.data.frame}
\alias{depDisplay.DepSearch}
\title{Generate a departure display}
\usage{
depDisplay(x, y, ..., pair, quants)

\method{depDisplay}{default}(x, y, ..., quants, border)

\method{depDisplay}{data.frame}(x, ..., pair, quants, border)

\method{depDisplay}{DepSearch}(x, ..., pair, quants, border)
}
\arguments{
\item{x}{a `data.frame`, `DepSearch` object, or a vector}

\item{y}{an optional vector, only used if `x` is a vector}

\item{...}{additional arguments to pass to plot}

\item{pair}{the pair of variables to display when `x` is a
`data.frame` or an `DepSearch`. If `x` is a `data.frame`, pair can
be specified in three ways: as a string with format "<y>:<z>",
as a character vector of length two, or as a numeric vector of
length two specifying the pair of variables to bin. If `x` is
an `DepSearch`, pair must be either a number or a string of the
format "<y>:<z>" specifying which binned pair of `x` to display.}

\item{quants}{list of two named vectors `x` and `y` providing the
quantiles to display on the corresponding axis in the case it is
a continuous variable. Defaults to the five number summary.}

\item{border}{string providing the colour of bin borders to draw,
NA suppresses borders}
}
\value{
Invisibly returns the binning obtained and generates a
departure display of the pairwise dependence.
}
\description{
This is a generic function which generates a
departure display to show the dependence between pairs of
variables for several common data structures.
}
\details{
depDisplay

`depDisplay` is a wrapper of the `plotBinning` function
with defaults set to be informative for most investigations.
}
\section{Methods (by class)}{
\itemize{
\item \code{depDisplay(default)}: Default depDisplay method

\item \code{depDisplay(data.frame)}: data.frame method for depDisplay

\item \code{depDisplay(DepSearch)}: DepSearch method for depDisplay

}}
\examples{
x <- rnorm(100)
y <- factor(abs(round(x*2)))
depDisplay(x, y)

## on the iris data
data(iris)
firstPair <- depDisplay(iris, pair = c(1,2))
## another way
firstPair2 <- depDisplay(iris, pair = c("Sepal.Length", "Sepal.Width"))
## a final way
firstPair2 <- depDisplay(iris, pair = "Sepal.Length:Sepal.Width")
}
\author{
Chris Salahub
}
