% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allen-relations.R
\name{allen_relation_code}
\alias{allen_relation_code}
\alias{allen_relation_string}
\alias{allen_relation_concurrent}
\alias{allen_relation_distinct}
\title{The Basic Allen Relation Set}
\usage{
allen_relation_code(...)

allen_relation_string(...)

allen_relation_concurrent(...)

allen_relation_distinct(...)
}
\arguments{
\item{...}{Currently not used.}
}
\value{
\itemize{
\item \code{allen_relation_code()} returns a \code{\link{character}} vector of one-letter codes
for the thirteen basic Allen relations.
\item \code{allen_relation_string()} returns a \code{\link{character}} vector of string
descriptors of the Allen basic relations.
\item \code{allen_relation_concurrent()} returns a \code{\link{character}} vector of nine
one-letter codes for the Allen concurrent relations.
\item \code{allen_relation_distinct()} returns the six value Allen relation set for
intervals with distinct endpoints.
}
}
\description{
The Basic Allen Relation Set
}
\note{
The codes were proposed by Thomas Alspaugh.
}
\references{
Allen, J. F. (1983). Maintaining Knowledge about Temporal Intervals.
\emph{Communications of the ACM}, 26(11): 832-843. \doi{10.1145/182.358434}.

Alspaugh, T. (2019). Allen's Interval Algebra.
URL: \url{https://thomasalspaugh.org/pub/fnd/allen.html}.
}
\seealso{
Other Allen's intervals: 
\code{\link{allen_analyze}()},
\code{\link{allen_complement}()},
\code{\link{allen_composition}()},
\code{\link{allen_converse}()},
\code{\link{allen_illustrate}()},
\code{\link{allen_intersect}()},
\code{\link{allen_joint_concurrency}()},
\code{\link{allen_observe}()},
\code{\link{allen_observe_frequency}()},
\code{\link{allen_relation}()},
\code{\link{allen_union}()}
}
\author{
T. S. Dye
}
\concept{Allen's intervals}
