% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSCFTest.R
\name{DSCFTest}
\alias{DSCFTest}
\title{Dwass-Steel-Critchlow-Fligner (DSCF) Test (Non-Parametric)}
\usage{
DSCFTest(formula, data, alpha = 0.05, method.p = "holm")
}
\arguments{
\item{formula}{A formula of the form \code{y ~ group}.}

\item{data}{A data frame containing the variables.}

\item{alpha}{Significance level (default is 0.05).}

\item{method.p}{Method for p-value adjustment (default is "holm").}
}
\value{
An object of class \code{"dscf"} and \code{"comparaciones"}, including:
\itemize{
  \item \code{Resultados}: Data frame with comparisons, z-statistics, p-values, adjusted p-values, and significance levels.
  \item \code{Promedios}: Mean ranks of each group.
  \item \code{Orden_Medias}: Group names ordered from highest to lowest mean rank.
  \item \code{Metodo}: "DSCF (no paramétrico)".
}
}
\description{
Robust non-parametric method for multiple comparisons after Kruskal-Wallis.
Uses rank-based pairwise tests with a pooled variance estimate.
}
\details{
Advantages:
- Strong control of Type I error with unequal sample sizes.
- More powerful than Dunn in many conditions.

Disadvantages:
- Computationally more complex.
- Less commonly available in standard software.
}
\examples{
data(d_e, package = "Analitica")
DSCFTest(Sueldo_actual ~ labor, data = d_e)


}
\references{
Dwass, M. (1960). Some k-sample rank-order tests. In I. Olkin et al. (Eds.), Contributions to Probability and Statistics: Essays in Honor of Harold Hotelling (pp. 198–202). Stanford University Press.
}
