% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JonckheereTest.R
\name{JT_Test}
\alias{JT_Test}
\title{Jonckheere-Terpstra Test for Ordered Alternatives (with Tie Correction)}
\usage{
JT_Test(formula, data)
}
\arguments{
\item{formula}{A formula of the type y ~ group, where `group` is an ordered factor.}

\item{data}{A data.frame containing the variables in the formula.}
}
\value{
An object of class "jonckheere" with:
\itemize{
  \item \code{J}: Total Jonckheere-Terpstra statistic.
  \item \code{J_pares}: Pairwise J statistics between group combinations.
  \item \code{mu_J}: Expected value of J under the null hypothesis.
  \item \code{var_J}: Variance of J (with complete tie correction).
  \item \code{Z}: Standardized test statistic.
  \item \code{p_value}: Two-sided p-value.
  \item \code{Trend}: Detected trend ("increasing", "decreasing", or "none").
  \item \code{Method}: Description of the method.
}
}
\description{
Performs the Jonckheere-Terpstra test to evaluate the presence of a monotonic trend
(increasing or decreasing) across three or more independent ordered groups.
This test is non-parametric and is particularly useful when the independent variable
is ordinal and the response is continuous or ordinal.
}
\details{
The Jonckheere-Terpstra test compares all pairwise combinations of groups and counts
the number of times values in higher-ordered groups exceed those in lower-ordered groups.
This implementation includes a full correction for ties in the data, which ensures more accurate inference.

Advantages:
- Non-parametric: does not assume normality or equal variances.
- More powerful than Kruskal-Wallis when there is an a priori ordering of groups.
- Tie correction included, improving robustness in real-world data.

Disadvantages:
- Requires that the group variable be ordered (ordinal).
- Detects overall trend but not specific group differences.
- Sensitive to large numbers of ties or very unbalanced group sizes.
}
\examples{
df <- data.frame(
  group = factor(rep(1:3, each = 6), ordered = TRUE),
  y = c(40,35,38,43,44,41,38,40,47,44,40,42,48,40,45,43,46,44)
)
res <- JT_Test(y ~ group, data = df)

}
\references{
Hollander, M., Wolfe, D. A., & Chicken, E. (2014). Nonparametric statistical methods. p. 202 (3rd ed.). Wiley.
}
