% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOPA-random.R
\name{rBernoulli}
\alias{rBernoulli}
\alias{GRP}
\alias{gSwitch}
\title{Generating random proportions with GRP}
\usage{
GRP( props, n, BSDesign=NULL, WSDesign=NULL, sname = "s" )

rBernoulli(n, p)
}
\arguments{
\item{n}{How many simulated participants are in each between-subject group (can be a vector, one per group);}

\item{p}{a proportion of success;}

\item{BSDesign}{A list with the between-subject factor(s) and the categories within each;}

\item{WSDesign}{A list with the within-subject factor(s) and the categories within each;}

\item{props}{(optional) the proportion of succes in each cell of the design. Default 0.50;}

\item{sname}{(optional) the column name that will contain the success/failure;}
}
\value{
\code{GRP()} returns a data frame containing success (coded as 1) or failure (coded as 0)
for n participants per cells of the design. Note that correlated
scores cannot be generated by \code{GRP()}; see \insertCite{ld98}{ANOPA}.
\code{rBernoulli()} returns a sequence of n success (1) or failures (0)
}
\description{
The function 'GRP()'
generates random proportions based on a design, i.e.,
a list giving the factors and the categories with each factor.
The data are returned in the 'wide' format.
}
\details{
The name of the function \code{GRP()} is derived from \code{GRD()},
a general-purpose tool to generate random data \insertCite{ch19}{ANOPA}
now bundled in the \code{superb} package \insertCite{cgh21}{ANOPA}.
\code{GRP()} is actually a proxy for \code{GRD()}.
}
\examples{

# The first example generate scorse for 20 particants in one factor having
# two categories (low and high):
design <- list( A=c("low","high"))
GRP( design, props = c(0.1,  0.9), n = 20 )

# This example has two factors, with factor A having levels a, b, c
# and factor B having 2 levels, for a total of 6 conditions;
# with 40 participants per group, it represents 240 observations:
design <- list( A=letters[1:3], B = c("low","high"))
GRP( design, props = c(0.1, 0.15, 0.20, 0.80, 0.85, 0.90), n = 40 )

# groups can be unequal:
design <- list( A=c("low","high"))
GRP( design, props = c(0.1,  0.9), n = c(5, 35) )

# Finally, repeated-measures can be generated
# but note that correlated scores cannot be generated with `GRP()`
wsDesign = list( Moment = c("pre", "post") )
GRP( WSDesign=wsDesign, props = c(0.1,  0.9), n = 10 )

# This last one has three factors, for a total of 3 x 2 x 2 = 12 cells
design <- list( A=letters[1:3], B = c("low","high"), C = c("cat","dog"))
GRP( design, n = 30, props = rep(0.5,12) )

# To specify unequal probabilities, use
design  <- list( A=letters[1:3], B = c("low","high"))
expProp <- c(.05, .05, .35, .35, .10, .10 )
GRP( design, n = 30, props=expProp )

# The name of the column containing the proportions can be changed
GRP( design, n=30, props=expProp, sname="patate")

# Examples of use of rBernoulli
t <- rBernoulli(50, 0.1)
mean(t)




}
\references{
\insertAllCited{}
}
