% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aldex-summary.R
\name{summary.aldex}
\alias{summary.aldex}
\title{Summary Method for ALDEx3 Objects}
\usage{
\method{summary}{aldex}(object, ignore.intercept = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{aldex}}

\item{ignore.intercept}{(default=TRUE), ignore intercept when creating
summary table}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A \code{data.frame} with columns \code{parameter}, \code{entity},
\code{p.val.adjusted}, \code{estimate}, and \code{std.error}.
}
\description{
Summarize an ALDEx3 result object
}
\details{
Provides a summary of the adjusted p-values, estimates, and standard errors
from an ALDEx3 result object.

This method extracts adjusted p-values from \code{object$p.val.adj}, along with
posterior estimates and standard errors averaged across Monte Carlo samples.
The result is returned as a long-format data.frame suitable for downstream
analysis or visualization.
}
\author{
Justin Silverman
}
