\name{smooth.construct.cr.smooth.spec}
\alias{smooth.construct.cr.smooth.spec}
\alias{smooth.construct.cs.smooth.spec}
\alias{smooth.construct.cc.smooth.spec}
\alias{cubic.regression.spline}
\alias{cyclic.cubic.spline}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Penalized Cubic regression splines in GAMs}

\description{\code{\link{gam}} can use univariate penalized cubic regression spline smooths, specified via terms like
\code{s(x,bs="cr")}. \code{s(x,bs="cs")} specifies a penalized cubic regression spline which has had its penalty modified 
to shrink towards zero at high enough smoothing parameters (as the smoothing parameter goes to infinity a normal cubic spline tends to a 
straight line.) \code{s(x,bs="cc")} specifies a cyclic penalized cubic regression spline smooth.

`Cardinal' spline bases are used: Wood (2017) sections 5.3.1 and 5.3.2 gives full details. These bases have 
very low setup costs. For a given basis dimension, \code{k}, they typically perform a little less well 
then thin plate regression splines, but a little better than p-splines. See \code{\link{te}} to use these bases in tensor product smooths of several variables.

Default \code{k} is 10. 
}

\usage{
\method{smooth.construct}{cr.smooth.spec}(object, data, knots)
\method{smooth.construct}{cs.smooth.spec}(object, data, knots)
\method{smooth.construct}{cc.smooth.spec}(object, data, knots)
}

\arguments{ 
\item{object}{a smooth specification object, usually generated by a term \code{s(...,bs="cr",...)},
      \code{s(...,bs="cs",...)} or \code{s(...,bs="cc",...)}}

\item{data}{a list containing just the data (including any \code{by} variable) required by this term, 
            with names corresponding to \code{object$term} (and \code{object$by}). The \code{by} variable 
            is the last element.} 

\item{knots}{a list containing any knots supplied for basis setup --- in same order and with same names as \code{data}. 
             Can be \code{NULL}. See details.}

}

\value{ An object of class \code{"cr.smooth"} \code{"cs.smooth"} or \code{"cyclic.smooth"}.
 In addition to the usual elements of a smooth class documented under \code{\link{smooth.construct}}, 
this object will contain:
\item{xp}{giving the knot locations used to generate the basis.}
\item{F}{ For class \code{"cr.smooth"} and \code{"cs.smooth"} objects  \code{t(F)} transforms function values 
          at the knots to second derivatives at the knots.}
\item{BD}{class \code{"cyclic.smooth"} objects include matrix \code{BD} which transforms function values 
          at the knots to second derivatives at the knots.}
}

\details{ 
The constructor is not normally called directly, but is rather used internally by \code{\link{gam}}. 
To use for basis setup it is recommended to use \code{\link{smooth.construct2}}.  

If they are not supplied then the knots  of the spline are placed evenly
  throughout the covariate values to which the term refers:  For
  example, if fitting 101 data with an 11 knot spline of \code{x} then
  there would be a knot at every 10th (ordered)  \code{x} value. The
  parameterization used represents the spline in terms of its
   values at the knots. The values at neighbouring knots
     are connected by sections of  cubic polynomial constrained to be 
     continuous up to and including second derivative at the knots. The resulting curve
     is a natural cubic  spline through the values at the knots (given two extra conditions specifying 
     that the second derivative of the curve should be zero at the two end 
     knots).

The shrinkage version of the smooth, eigen-decomposes the wiggliness penalty matrix, and sets its 2 zero eigenvalues to small 
multiples of the smallest strictly positive eigenvalue. The penalty is then set to the matrix with eigenvectors corresponding 
to those of the original penalty, but eigenvalues set to the peturbed versions. This penalty matrix has full rank and shrinks 
the curve to zero at high enough smoothing parameters.

Note that the cyclic smoother will wrap at the smallest and largest covariate values, unless knots are supplied. If only two 
knots are supplied then they are taken as the end points of the smoother (provided all the data lie between them), and the 
remaining knots are generated automatically.

The cyclic smooth is not 
subject to the condition that second derivatives go to zero at the first and last knots.
}

\references{
Wood S.N. (2017) Generalized Additive Models: An Introduction with R (2nd edition). Chapman
and Hall/CRC Press.
}

\author{ Simon N. Wood \email{simon.wood@r-project.org}}

\examples{
## cyclic spline example...
  require(mgcv)
  set.seed(6)
  x <- sort(runif(200)*10)
  z <- runif(200)
  f <- sin(x*2*pi/10)+.5
  y <- rpois(exp(f),exp(f)) 

## finished simulating data, now fit model...
  b <- gam(y ~ s(x,bs="cc",k=12) + s(z),family=poisson,
                      knots=list(x=seq(0,10,length=12)))
## or more simply
   b <- gam(y ~ s(x,bs="cc",k=12) + s(z),family=poisson,
                      knots=list(x=c(0,10)))

## plot results...
  par(mfrow=c(2,2))
  plot(x,y);plot(b,select=1,shade=TRUE);lines(x,f-mean(f),col=2)
  plot(b,select=2,shade=TRUE);plot(fitted(b),residuals(b))
  

}
\keyword{models} \keyword{regression}%-- one or more ..


